/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine;

import fr.exemole.bdfserver.api.balayage.FileGenerationListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.balayage.SiteMapOption;
import net.mapeadores.util.xml.DefaultXMLWriter;

public class SiteMapBuilder
implements FileGenerationListener {
    private final List<String> urlList = new ArrayList<String>();
    private final SiteMapOption siteMapOption;

    public SiteMapBuilder(SiteMapOption siteMapOption) {
        this.siteMapOption = siteMapOption;
    }

    @Override
    public void generateFile(String langDir, String path, String fileName) {
        if (!fileName.endsWith(".html")) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (langDir != null) {
            buf.append(langDir);
            buf.append('/');
        }
        if (path != null && path.length() > 0) {
            buf.append(path);
            buf.append('/');
        }
        buf.append(fileName);
        this.urlList.add(buf.toString());
    }

    public String writeSiteMapFile(File directory) throws IOException {
        String path = this.siteMapOption.getPath();
        if (path != null) {
            directory = new File(directory, path);
        }
        File destination = new File(directory, this.siteMapOption.getFileName());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destination), "UTF-8"));){
            SiteMapWriter siteMapWriter = new SiteMapWriter(this.siteMapOption.getBaseUrl());
            siteMapWriter.setAppendable(writer);
            siteMapWriter.appendXMLDeclaration();
            siteMapWriter.setIndentLength(-999);
            siteMapWriter.start();
            for (String url : this.urlList) {
                siteMapWriter.addUrl(url);
            }
            siteMapWriter.end();
        }
        return destination.getPath();
    }

    private static class SiteMapWriter
    extends DefaultXMLWriter {
        private String baseUrl;

        SiteMapWriter(String baseUrl) {
            this.baseUrl = baseUrl == null ? "" : baseUrl;
        }

        public void start() throws IOException {
            this.startOpenTag("urlset");
            this.addAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
            this.endOpenTag();
        }

        public void addUrl(String url) throws IOException {
            this.openTag("url");
            this.addSimpleElement("loc", this.baseUrl + url);
            this.closeTag("url");
        }

        public void end() throws IOException {
            this.closeTag("urlset");
        }
    }
}

