/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.jsonproducers.administration.ResourceTreeJsonProperty;
import fr.exemole.bdfserver.jsonproducers.administration.RoleArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.administration.RoleJsonProperty;
import fr.exemole.bdfserver.jsonproducers.administration.StreamTextJsonProperty;
import fr.exemole.bdfserver.jsonproducers.administration.UrlInfosJsonProperty;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import java.net.URI;
import java.util.Collection;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;

public final class AdministrationJsonProducerFactory {
    private AdministrationJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = AdministrationJsonProducerFactory.getJsonProperty(parameters, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputParameters parameters, String name) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        BdfServer bdfServer = parameters.getBdfServer();
        Lang lang = parameters.getWorkingLang();
        switch (name) {
            case "resource-tree": {
                bdfServer.getL10nManager().update();
                bdfServer.getTransformationManager().update();
                bdfServer.getJsLibManager().update();
                bdfServer.getJsAnalyser().clearCache();
                return new ResourceTreeJsonProperty(bdfServer.getResourceStorages());
            }
            case "streamtext": {
                String path = requestHandler.getMandatoryPath();
                URI uri = BdfURI.toAbsoluteBdfURI(path);
                if (uri == null) {
                    throw BdfErrors.wrongParameterValue("path", path);
                }
                return new StreamTextJsonProperty(bdfServer, uri);
            }
            case "role-array": {
                permissionChecker.checkFichothequeAdmin();
                return new RoleArrayJsonProperty(bdfServer, lang);
            }
            case "role": {
                permissionChecker.checkFichothequeAdmin();
                Role role = requestHandler.getRole();
                return new RoleJsonProperty(role, lang);
            }
            case "urlinfos": {
                permissionChecker.checkFichothequeAdmin();
                Collection infos = (Collection)parameters.getResultObject("obj.urlinfocollection");
                if (infos != null) {
                    return new UrlInfosJsonProperty(infos, parameters.getBdfUser());
                }
                throw BdfErrors.missingCommandResultJson("urlinfos");
            }
        }
        return null;
    }
}

