/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.impl.BdfUserPrefsImpl;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.fichotheque.EditOrigin;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.UserConditionBuilder;
import net.fichotheque.utils.EditOriginUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.text.TypoOptions;

class BdfUserImpl
implements BdfUser {
    private static long lastBdfSessionId = 0L;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();
    private final String bdfServerName;
    private final LoginKey loginKey;
    private final Redacteur redacteur;
    private final BdfUserPrefsImpl prefs;
    private FicheQuery simpleFicheQuery;
    private Fiches selectedFiches = null;
    private Object selectionObject;
    private final String bdfSessionId;
    private Lang workingLang;
    private Locale formatLocale;
    private LangPreference langPreference;

    private BdfUserImpl(String bdfServerName, Redacteur redacteur) {
        this.bdfServerName = bdfServerName;
        this.loginKey = LoginKey.build(redacteur.getSubsetKey(), redacteur.getLogin());
        this.bdfSessionId = BdfUserImpl.getNewBdfSessionId();
        this.redacteur = redacteur;
        this.prefs = new BdfUserPrefsImpl(this);
        this.prefs.defaultFicheQuery = this.simpleFicheQuery = FicheQueryBuilder.init().setUserCondition(UserConditionBuilder.init().addId(redacteur).toUserCondition()).toFicheQuery();
        this.selectionObject = this.simpleFicheQuery;
    }

    void updateLocalisation(BdfServer bdfServer) {
        this.workingLang = this.prefs.getWorkingLang();
        if (this.workingLang == null) {
            this.workingLang = bdfServer.getDefaultWorkingLang();
        }
        this.formatLocale = this.prefs.getCustomFormatLocale();
        if (this.formatLocale == null) {
            this.formatLocale = this.workingLang.toLocale();
        }
        this.putParameter("bdf.form.typooptions", TypoOptions.getTypoOptions(this.formatLocale));
        LangPreferenceBuilder langPreferenceBuilder = new LangPreferenceBuilder();
        LangPreference customLangPreference = this.prefs.getCustomLangPreference();
        if (customLangPreference != null) {
            langPreferenceBuilder.addLangs(customLangPreference);
        }
        langPreferenceBuilder.addLang(this.workingLang);
        ConfigurationUtils.checkLangPreference(bdfServer.getLangConfiguration(), langPreferenceBuilder);
        this.langPreference = langPreferenceBuilder.toLangPreference();
    }

    @Override
    public LoginKey getLoginKey() {
        return this.loginKey;
    }

    @Override
    public String getBdfServerName() {
        return this.bdfServerName;
    }

    @Override
    public Redacteur getRedacteur() {
        return this.redacteur;
    }

    @Override
    public BdfUserPrefs getPrefs() {
        return this.prefs;
    }

    @Override
    public Lang getWorkingLang() {
        return this.workingLang;
    }

    @Override
    public Locale getFormatLocale() {
        return this.formatLocale;
    }

    @Override
    public LangPreference getLangPreference() {
        return this.langPreference;
    }

    @Override
    public FicheQuery getFicheQuery() {
        return this.simpleFicheQuery;
    }

    @Override
    public Fiches getSelectedFiches() {
        return this.selectedFiches;
    }

    @Override
    public Object getParameterValue(String parameterName) {
        return this.parameterMap.get(parameterName);
    }

    @Override
    public void putParameter(String parameterName, Object parameterValue) {
        this.parameterMap.put(parameterName, parameterValue);
    }

    @Override
    public EditOrigin newEditOrigin(String source) {
        Object alternateGlobalId = this.getParameterValue("bdf.edit.alternateglobalid");
        String globalId = alternateGlobalId != null ? alternateGlobalId.toString() : this.redacteur.getGlobalId();
        return EditOriginUtils.newEditOrigin(source, this.bdfSessionId, globalId);
    }

    void setFicheQuery(FicheQuery ficheQuery) {
        if (ficheQuery == null) {
            throw new IllegalArgumentException("ficheQuery is null");
        }
        this.simpleFicheQuery = ficheQuery;
        this.selectionObject = ficheQuery;
    }

    void setFicheSelection(BdfServer bdfServer, Object selectionObject, String sortType) {
        if (selectionObject == null) {
            throw new IllegalArgumentException("selectionObject is null");
        }
        this.selectionObject = selectionObject;
        if (selectionObject instanceof FicheQuery) {
            this.simpleFicheQuery = (FicheQuery)selectionObject;
        }
        this.updateFicheSelection(bdfServer, sortType);
    }

    void setSelectedFiches(Fiches fiches) {
        this.selectedFiches = fiches;
        this.selectionObject = null;
    }

    boolean updateFicheSelection(BdfServer bdfServer, String sortType) {
        if (this.selectionObject == null) {
            return false;
        }
        FicheSelectorBuilder ficheSelectorBuilder = FicheSelectorBuilder.init(this.getSelectionContext(bdfServer));
        if (this.selectionObject instanceof FicheQuery) {
            ficheSelectorBuilder.add((FicheQuery)this.selectionObject);
        } else if (this.selectionObject instanceof FichothequeQueries) {
            for (FicheQuery ficheQuery : ((FichothequeQueries)this.selectionObject).getFicheQueryList()) {
                ficheSelectorBuilder.add(ficheQuery);
            }
        } else if (this.selectionObject instanceof String) {
            SelectionDef selectionDef = bdfServer.getSelectionManager().getSelectionDef((String)this.selectionObject);
            if (selectionDef != null) {
                for (FicheQuery ficheQuery : selectionDef.getFichothequeQueries().getFicheQueryList()) {
                    ficheSelectorBuilder.add(ficheQuery);
                }
                this.putParameter("bdf.selection.defname", this.selectionObject);
            } else {
                return false;
            }
        }
        this.selectedFiches = FichesBuilder.build(sortType, this.getWorkingLang()).initSubsetKeyOrder(TreeUtils.getCorpusKeyList(bdfServer)).populate(ficheSelectorBuilder.toFicheSelector()).toFiches();
        return true;
    }

    private SelectionContext getSelectionContext(BdfServer bdfServer) {
        PermissionSummary permissionSummary = PermissionSummaryBuilder.build(bdfServer, this);
        return BdfServerUtils.initSelectionContextBuilder(bdfServer, this.getWorkingLang()).setSubsetAccessPredicate(permissionSummary.getSubsetAccessPredicate()).setFichePredicate(PermissionUtils.getFichePredicate(permissionSummary)).toSelectionContext();
    }

    private void initBdfUserPrefs(BdfUserPrefs bdfUserPrefs) {
        this.prefs.init(bdfUserPrefs);
        FicheQuery defaultFicheQuery = bdfUserPrefs.getDefaultFicheQuery();
        if (defaultFicheQuery != null) {
            this.simpleFicheQuery = defaultFicheQuery;
            this.selectionObject = defaultFicheQuery;
        }
    }

    private static synchronized String getNewBdfSessionId() {
        long l = System.currentTimeMillis();
        if (l <= lastBdfSessionId) {
            l = lastBdfSessionId + 1L;
        }
        lastBdfSessionId = l;
        return String.valueOf(l);
    }

    static BdfUserImpl build(BdfServer bdfServer, Redacteur redacteur) {
        BdfUserImpl bdfUser = new BdfUserImpl(bdfServer.getName(), redacteur);
        BdfUserPrefs storagePrefs = bdfServer.getBdfUserStorage().getBdfUserPrefs(redacteur);
        if (storagePrefs != null) {
            bdfUser.initBdfUserPrefs(storagePrefs);
        }
        bdfUser.updateLocalisation(bdfServer);
        return bdfUser;
    }
}

