/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaMetadataFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.DocumentAdminFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.DocumentAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.DocumentChangeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.DocumentUploadConfirmHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.DocumentUploadHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.FileLength;

public final class AddendaHtmlProducerFactory {
    private static final int ADDENDA_ADMIN = 1;
    private static final int ADDENDA_READ = 2;
    private static final int DOCUMENT = 3;

    private AddendaHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        String page = parameters.getOutput();
        BdfCommandResult bdfCommandResult = parameters.getBdfCommandResult();
        switch (AddendaHtmlProducerFactory.getPageType(page)) {
            case 1: {
                Addenda addenda = requestHandler.getAddenda();
                permissionChecker.checkSubsetAdmin(addenda);
                switch (page) {
                    case "addenda-advancedcommands": {
                        return new AddendaAdvancedCommandsHtmlProducer(parameters, addenda);
                    }
                    case "addenda-metadataform": {
                        return new AddendaMetadataFormHtmlProducer(parameters, addenda);
                    }
                }
                return null;
            }
            case 2: {
                Addenda addenda = requestHandler.getAddenda();
                switch (page) {
                    case "addenda": {
                        return new AddendaHtmlProducer(parameters, addenda);
                    }
                    case "document-change": {
                        String callKey = requestHandler.getCallKey();
                        if (bdfCommandResult != null) {
                            DocumentChangeInfo documentChangeInfo = (DocumentChangeInfo)bdfCommandResult.getResultObject("obj.documentchangeinfo");
                            String originalName = (String)bdfCommandResult.getResultObject("obj.string");
                            return DocumentChangeHtmlProducer.newDocumentCreate(parameters, callKey, originalName, documentChangeInfo, addenda);
                        }
                        String changeType = requestHandler.getMandatoryParameter("changetype");
                        String changeInfoString = requestHandler.getTrimedParameter("change");
                        DocumentChangeInfo documentChangeInfo = DocumentChangeInfo.EMPTY;
                        if (!changeInfoString.isEmpty()) {
                            documentChangeInfo = DocumentChangeInfo.parse(changeInfoString);
                        }
                        if (changeType.equals("document")) {
                            Document document = requestHandler.getMandatoryDocument();
                            return DocumentChangeHtmlProducer.newDocumentChange(parameters, callKey, document, documentChangeInfo, addenda);
                        }
                        if (changeType.equals("creation")) {
                            if (documentChangeInfo.getNewBasename() == null || documentChangeInfo.getTmpFileCount() == 0) {
                                if (changeInfoString.isEmpty()) {
                                    throw BdfErrors.emptyMandatoryParameter("change");
                                }
                                throw BdfErrors.wrongParameterValue("change", changeInfoString);
                            }
                            String originalName = requestHandler.getTrimedParameter("originalname");
                            return DocumentChangeHtmlProducer.newDocumentCreate(parameters, callKey, originalName, documentChangeInfo, addenda);
                        }
                        throw BdfErrors.unknownParameterValue("changetype", changeType);
                    }
                    case "document-upload-new": {
                        String callKey = requestHandler.getCallKey();
                        return DocumentUploadHtmlProducer.newNewUpload(parameters, callKey, addenda);
                    }
                    case "document-upload-version": {
                        String callKey = requestHandler.getCallKey();
                        return DocumentUploadHtmlProducer.newVersionUpload(parameters, callKey, addenda);
                    }
                }
                return null;
            }
            case 3: {
                Document document = requestHandler.getDocument();
                switch (page) {
                    case "document-adminform": {
                        permissionChecker.checkWrite(document);
                        return new DocumentAdminFormHtmlProducer(parameters, document);
                    }
                    case "document-advancedcommands": {
                        permissionChecker.checkSubsetAdmin(document.getAddenda());
                        return new DocumentAdvancedCommandsHtmlProducer(parameters, document);
                    }
                }
                return null;
            }
        }
        switch (page) {
            case "addenda-creationform": {
                permissionChecker.checkFichothequeAdmin();
                return new AddendaCreationFormHtmlProducer(parameters);
            }
            case "document-upload-confirm": {
                String callKey = requestHandler.getCallKey();
                if (bdfCommandResult != null) {
                    DocumentChangeInfo documentChangeInfo = (DocumentChangeInfo)bdfCommandResult.getResultObject("obj.documentchangeinfo");
                    FileLength fileLength = (FileLength)bdfCommandResult.getResultObject("obj.filelength");
                    return new DocumentUploadConfirmHtmlProducer(parameters, callKey, documentChangeInfo, fileLength);
                }
                return null;
            }
        }
        return null;
    }

    private static int getPageType(String page) {
        switch (page) {
            case "addenda-advancedcommands": 
            case "addenda-metadataform": {
                return 1;
            }
            case "addenda": 
            case "document-change": 
            case "document-upload-new": 
            case "document-upload-version": {
                return 2;
            }
            case "document-adminform": 
            case "document-advancedcommands": {
                return 3;
            }
        }
        return 0;
    }
}

