/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotcleStatusCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleStatus";
    public static final String COMMANDKEY = "_ THS-16";
    public static final String STATUS_PARAMNAME = "status";
    private Motcle motcle;
    private String newStatus;

    public MotcleStatusCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        Thesaurus thesaurus = this.motcle.getThesaurus();
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(thesaurus);
            done = thesaurusEditor.setStatus(this.motcle, this.newStatus);
        }
        this.putResultObject("obj.thesaurus", thesaurus);
        this.putResultObject("obj.motcle", this.motcle);
        if (done) {
            this.setDone("_ done.thesaurus.motclestatus", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        try {
            this.newStatus = FichothequeConstants.checkMotcleStatus(this.getMandatory(STATUS_PARAMNAME));
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(STATUS_PARAMNAME, this.newStatus);
        }
    }
}

