/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.commands.addenda.AddendaCommandFactory;
import fr.exemole.bdfserver.commands.administration.AdministrationCommandFactory;
import fr.exemole.bdfserver.commands.album.AlbumCommandFactory;
import fr.exemole.bdfserver.commands.configuration.ConfigurationCommandFactory;
import fr.exemole.bdfserver.commands.corpus.CorpusCommandFactory;
import fr.exemole.bdfserver.commands.edition.EditionCommandFactory;
import fr.exemole.bdfserver.commands.exportation.ExportationCommandFactory;
import fr.exemole.bdfserver.commands.importation.ImportationCommandFactory;
import fr.exemole.bdfserver.commands.mailing.MailingCommandFactory;
import fr.exemole.bdfserver.commands.selection.SelectionCommandFactory;
import fr.exemole.bdfserver.commands.sphere.SphereCommandFactory;
import fr.exemole.bdfserver.commands.thesaurus.ThesaurusCommandFactory;
import net.mapeadores.util.request.RequestMap;

public class CoreBdfCommandProvider
implements BdfCommandProvider {
    public static final BdfCommandProvider UNIQUE_INSTANCE = new CoreBdfCommandProvider();

    @Override
    public BdfCommand getBdfCommand(BdfCommandParameters bdfCommandParameters) {
        BdfServer bdfServer = bdfCommandParameters.getBdfServer();
        RequestMap requestMap = bdfCommandParameters.getRequestMap();
        String commandName = bdfCommandParameters.getCommandName();
        Domain domain = bdfCommandParameters.getDomain();
        switch (domain.getFirstPart()) {
            case "administration": {
                return AdministrationCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "album": {
                return AlbumCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "configuration": {
                return ConfigurationCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "corpus": {
                return CorpusCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "mailing": {
                return MailingCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "exportation": {
                return ExportationCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "edition": {
                return EditionCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "selection": {
                return SelectionCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "sphere": {
                return SphereCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "thesaurus": {
                return ThesaurusCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "addenda": {
                return AddendaCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
            case "importation": {
                return ImportationCommandFactory.getBdfCommand(bdfServer, requestMap, commandName);
            }
        }
        return null;
    }
}

