/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Locale;
import net.fichotheque.exportation.table.ColDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.util.date.DateUtils;
import net.mapeadores.util.text.Labels;

public abstract class TableEngine {
    private final ScarabeLocalisation scarabeLocalisation;

    public TableEngine(ScarabeLocalisation scarabeLocalisation) {
        this.scarabeLocalisation = scarabeLocalisation;
    }

    public ScarabeLocalisation getScarabeLocalisation() {
        return this.scarabeLocalisation;
    }

    public abstract OdTableDef getOdTableDef();

    public abstract String getTitle();

    public abstract void writeHead(ScarabeTableWriter var1);

    public abstract void writeBody(ScarabeTableWriter var1);

    public void writeTitles(ScarabeTableWriter tableWriter, List<ColDef> colDefList) {
        for (ColDef colDef : colDefList) {
            Labels labels = colDef.getCustomLabels();
            if (labels != null) {
                tableWriter.addStringCell(labels.seekLabelString(this.getScarabeLocalisation().getWorkingLang(), colDef.getColName()));
                continue;
            }
            String messageKey = (String)colDef.getParameterValue("messageKey");
            if (messageKey != null) {
                tableWriter.addMessageCell(messageKey);
                continue;
            }
            tableWriter.addStringCell(colDef.getColName());
        }
    }

    public String getDatePattern() {
        return DateUtils.getLocalizedPattern((FormatStyle)FormatStyle.MEDIUM, (Locale)this.scarabeLocalisation.getUserLangContext().getFormatLocale());
    }
}

