/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.detail;

import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.NaturalEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.detail.DetailEngine;
import net.mapeadores.util.money.Currencies;

class NaturalDetailEngine
extends DetailEngine {
    private final Currencies customCurrencies;

    NaturalDetailEngine(NaturalEngineParameters naturalEngineParameters) {
        this.customCurrencies = naturalEngineParameters.getCurrencies();
    }

    @Override
    public MoneyByCurrency toMoneyByCurrency(Ligne ligne) {
        return new InternalMoneyByCurrency(ligne.getMouvement().getCurrencyIndex(), ligne.getComputeMoneyLong());
    }

    @Override
    public MoneyByCurrency toMoneyByCurrency(Avenir avenir) {
        return new InternalMoneyByCurrency(avenir.getCurrencyIndex(), avenir.getComputeMoneyLong());
    }

    @Override
    public MutableMoneyByCurrency getMutableMoneyByCurrency() {
        return new MutableMoneyByCurrency(this.customCurrencies.size());
    }

    @Override
    public Currencies getCustomCurrencies() {
        return this.customCurrencies;
    }

    private static class InternalMoneyByCurrency
    implements MoneyByCurrency {
        private final int currencyIndex;
        private final long moneyLong;

        private InternalMoneyByCurrency(int currencyIndex, long moneyLong) {
            this.currencyIndex = currencyIndex;
            this.moneyLong = moneyLong;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean withMoney(int currencyIndex) {
            return currencyIndex == this.currencyIndex;
        }

        @Override
        public long getMoneyLong(int currencyIndex) {
            if (currencyIndex == this.currencyIndex) {
                return this.moneyLong;
            }
            return 0L;
        }
    }
}

