/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.json;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.ItemAnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeColDefs;
import fr.exemole.bdfext.scarabe.producers.json.AnalytiqueDetailsJsonProperty;
import fr.exemole.bdfext.scarabe.producers.json.AnalytiqueItemJsonProperty;
import fr.exemole.bdfext.scarabe.producers.json.AnalytiqueRecapJsonProperty;
import fr.exemole.bdfext.scarabe.producers.json.ColumnsJsonProperty;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.exportation.Columns;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.tools.exportation.table.CellConversionInit;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import fr.exemole.bdfserver.tools.interaction.PropertiesParam;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.CommandMessageJsonProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;

public final class JsonProducerFactory {
    private JsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters, ScarabeContext scarabeContext) throws ErrorMessageException {
        if (scarabeContext.getInitState() != 1) {
            return new CommandMessageJsonProducer(parameters.getMessageLocalisation(), new CommandMessage[]{LogUtils.error((String)ScarabeUtils.getInitL10nKey(scarabeContext), (Object[])new Object[0])});
        }
        OutputRequestHandler requestHandler = OutputRequestHandler.init((OutputParameters)parameters);
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        switch (parameters.getOutput()) {
            case "AnalytiqueDetails": 
            case "AnalytiqueItem": {
                JsonProducerFactory.addAnalytiqueDetailsResult(parameters, scarabeContext, jsonProducer);
                break;
            }
            case "AnalytiqueRecap": {
                AnalytiqueRecap analytiqueRecap = (AnalytiqueRecap)parameters.getResultObject("scarabe.obj_analytiquerecap");
                jsonProducer.add((JsonProperty)new AnalytiqueRecapJsonProperty((BdfParameters)parameters, scarabeContext, analytiqueRecap, BdfInstructionUtils.getCellConverter((OutputParameters)parameters)));
                break;
            }
            case "columns": {
                Subset subset = requestHandler.getMandatorySubset();
                Columns columns = Columns.build((BdfParameters)parameters, scarabeContext, parameters.getWorkingLang(), subset.getSubsetKeyString(), ScarabeColDefs.ANALYTIQUE_LIST);
                jsonProducer.add((JsonProperty)new ColumnsJsonProperty(columns, parameters.getMessageLocalisation(), parameters.getWorkingLang()));
                break;
            }
        }
        if (jsonProducer.isEmpty()) {
            return null;
        }
        return jsonProducer;
    }

    private static void addAnalytiqueDetailsResult(OutputParameters parameters, ScarabeContext scarabeContext, ResultJsonProducer jsonProducer) {
        CellConverter cellConverter;
        RequestMap requestMap = parameters.getRequestMap();
        AnalytiqueDetails analytiqueDetails = (AnalytiqueDetails)parameters.getResultObject("scarabe.obj_analytiquedetails");
        AnalytiqueRecap analytiqueRecap = (AnalytiqueRecap)parameters.getResultObject("scarabe.obj_analytiquerecap");
        boolean withColumns = requestMap.isTrue("withcolumns");
        boolean recursive = requestMap.isTrue("recursive");
        CellConverter recapCellConverter = JsonProducerFactory.getRecapCellConverter(parameters);
        if (PropertiesParam.hasPropertiesParam((RequestMap)requestMap)) {
            cellConverter = BdfInstructionUtils.getCellConverter((OutputRequestHandler)new OutputRequestHandler(parameters), (Corpus)JsonProducerFactory.getOptionalCorpus(analytiqueDetails), (CellConverter)TableExportUtils.EMPTY_CELLCONVERTER);
            if (recapCellConverter == null) {
                recapCellConverter = cellConverter;
            }
        } else {
            Columns columns = Columns.build((BdfParameters)parameters, scarabeContext, parameters.getWorkingLang(), analytiqueDetails.getAnalytiqueSubset().getSubsetKey().getKeyString(), ScarabeColDefs.ANALYTIQUE_LIST);
            cellConverter = columns.getCellConverter();
            if (withColumns) {
                jsonProducer.add((JsonProperty)new ColumnsJsonProperty(columns, parameters.getMessageLocalisation(), parameters.getWorkingLang()));
            }
            if (recapCellConverter == null) {
                recapCellConverter = TableExportUtils.EMPTY_CELLCONVERTER;
            }
        }
        switch (parameters.getOutput()) {
            case "AnalytiqueDetails": {
                jsonProducer.add((JsonProperty)new AnalytiqueDetailsJsonProperty((BdfParameters)parameters, scarabeContext, analytiqueDetails, analytiqueRecap, cellConverter, recapCellConverter, recursive));
                break;
            }
            case "AnalytiqueItem": {
                if (!(analytiqueDetails instanceof ItemAnalytiqueDetails)) break;
                jsonProducer.add((JsonProperty)new AnalytiqueItemJsonProperty((BdfParameters)parameters, scarabeContext, (ItemAnalytiqueDetails)analytiqueDetails, analytiqueRecap, cellConverter, recapCellConverter, recursive));
            }
        }
    }

    private static Corpus getOptionalCorpus(AnalytiqueDetails analytiqueDetails) {
        Subset subset = analytiqueDetails.getAnalytiqueSubset().getSubset();
        if (subset instanceof Corpus) {
            return (Corpus)subset;
        }
        return null;
    }

    private static CellConverter getRecapCellConverter(OutputParameters outputParameters) {
        PropertiesParam propertiesParam = PropertiesParam.fromRequest((RequestMap)outputParameters.getRequestMap(), (String)"recapProperties", null);
        if (propertiesParam == null) {
            return null;
        }
        if (propertiesParam.isTableExport()) {
            ExtractionContext extractionContext = outputParameters.getDefaultExtractionContext();
            try {
                return CellConversionInit.fromTableExportName((BdfServer)outputParameters.getBdfServer(), (ExtractionContext)extractionContext, (String)propertiesParam.getName()).getCellConverter();
            }
            catch (ErrorMessageException eme) {
                return null;
            }
        }
        return null;
    }
}

