/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueParametersBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.ConversionEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.EngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.NaturalEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.RecapEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class AnalytiqueRecapCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AnalytiqueRecap";
    public static final String CONVERSION_PARAMNAME = "conversion";
    public static final String SELECTION_PARAMNAME = "selection";
    public static final String INCLUDE_PARAMNAME = "include";
    public static final String EXCLUDE_PARAMNAME = "exclude";
    public static final String INCLUDE_IDALPHA_PARAMNAME = "include_idalpha";
    public static final String EXCLUDE_IDALPHA_PARAMNAME = "exclude_idalpha";
    public static final String HIDE_ROOT_PARAMNAME = "hide_root";
    private final Recapitulatif recapitulatif;
    private final ScarabeContext scarabeContext;
    private EngineParameters engineParameters;
    private Predicate<FicheMeta> ligneFichePredicate;
    private AnalytiqueParameters analytiqueParameters;

    public AnalytiqueRecapCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(bdfServer);
    }

    public boolean needSynchronisation() {
        return false;
    }

    protected void doCommand() throws ErrorMessageException {
        AnalytiqueDef analytiqueDef = this.analytiqueParameters.getMode() != 1 ? this.analytiqueParameters.getAnalytiqueSubset().getAnalytiqueDef() : AnalytiqueUtils.DEFAULT_ANALYTIQUEDEF;
        List<OperationDef> operationDefList = analytiqueDef.getOperationDefList();
        OperationDef[] operationDefArray = operationDefList.toArray(new OperationDef[operationDefList.size()]);
        RecapEngine recapEngine = RecapEngine.newRecapEngine(this.engineParameters, this.analytiqueParameters, null, this.ligneFichePredicate, operationDefArray);
        AnalytiqueRecap rootRecap = recapEngine.buildFromRoot();
        this.putResultObject("scarabe.obj_analytiquerecap", rootRecap);
    }

    protected void checkParameters() throws ErrorMessageException {
        String conversionString;
        ScarabeUtils.checkInitState(this.scarabeContext);
        Subset subset = this.requestHandler.getMandatorySubset();
        SubsetKey subsetKey = subset.getSubsetKey();
        AnalytiqueSubset analytiqueSubset = this.recapitulatif.getAnalytiqueSubset(subsetKey);
        if (analytiqueSubset == null) {
            throw BdfErrors.error((String)"_ error.unsupported.scarabe.noanalytiquesubset", (Object[])new Object[]{subsetKey});
        }
        if (analytiqueSubset.hasError()) {
            throw BdfErrors.error((String)"_ error.unsupported.scarabe.noanalytiquesubset", (Object[])new Object[]{subsetKey});
        }
        AnalytiqueParametersBuilder builder = new AnalytiqueParametersBuilder(analytiqueSubset);
        if (this.requestHandler.isTrue(SELECTION_PARAMNAME)) {
            this.ligneFichePredicate = this.bdfUser.getSelectedFiches();
            builder.setMode((short)1);
        }
        if (this.requestHandler.isTrue(HIDE_ROOT_PARAMNAME)) {
            builder.setHideRootRecap(true);
        }
        if (!(conversionString = this.requestHandler.getTrimedParameter(CONVERSION_PARAMNAME)).isEmpty()) {
            try {
                ExtendedCurrency currency = ExtendedCurrency.parse((String)conversionString);
                builder.setConversionCurrency(currency);
                this.engineParameters = new ConversionEngineParameters(this.recapitulatif.getCoursManager(), currency, this.recapitulatif.getCurrencies());
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue((String)CONVERSION_PARAMNAME, (String)conversionString);
            }
        } else {
            this.engineParameters = new NaturalEngineParameters(this.recapitulatif.getCurrencies());
        }
        builder.setIncludeIdSet(AnalytiqueRecapCommand.parseSet(analytiqueSubset, this.requestHandler.getTrimedParameter(INCLUDE_PARAMNAME), this.requestHandler.getTrimedParameter(INCLUDE_IDALPHA_PARAMNAME)));
        builder.setExcludeIdSet(AnalytiqueRecapCommand.parseSet(analytiqueSubset, this.requestHandler.getTrimedParameter(EXCLUDE_PARAMNAME), this.requestHandler.getTrimedParameter(EXCLUDE_IDALPHA_PARAMNAME)));
        this.analytiqueParameters = builder.toAnalytiqueParameters();
    }

    public static Set<Integer> parseSet(AnalytiqueSubset analytiqueSubset, String idString, String idalphaString) {
        Thesaurus thesaurus;
        Subset subset;
        Object idalphaThesaurus = null;
        HashSet<Integer> set = new HashSet<Integer>();
        if (!idString.isEmpty()) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens((String)idString, (boolean)true)) {
                try {
                    Integer itg = Integer.parseInt(token);
                    set.add(itg);
                }
                catch (NumberFormatException nfe) {
                    Motcle motcle;
                    if (idalphaThesaurus == null || (motcle = idalphaThesaurus.getMotcleByIdalpha(token)) == null) continue;
                    set.add(motcle.getId());
                }
            }
        }
        if (!idalphaString.isEmpty() && (subset = analytiqueSubset.getSubset()) instanceof Thesaurus && (thesaurus = (Thesaurus)subset).isIdalphaType()) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens((String)idalphaString, (boolean)false)) {
                Motcle motcle = thesaurus.getMotcleByIdalpha(token);
                if (motcle == null) continue;
                set.add(motcle.getId());
            }
        }
        return set;
    }
}

