/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.instructions.ComptagenEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.Map;
import net.fichotheque.alias.AliasHolder;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;

public class ScarabeBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private final Map<String, String> instructionMap;
    private final RequestMap requestMap;
    private final BdfServer bdfServer;
    private final ScarabeContext scarabeContext;

    public ScarabeBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> instructionMap, ScarabeContext scarabeContext) {
        this.instructionMap = instructionMap;
        this.requestMap = requestMap;
        this.bdfServer = bdfServer;
        this.scarabeContext = scarabeContext;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        String instruction = this.instructionMap.get("instruction");
        if (instruction == null) {
            return null;
        }
        if (!BdfUserUtils.isAdmin((BdfServer)this.bdfServer, (BdfUser)bdfUser)) {
            return null;
        }
        if (instruction.equals("Comptagen")) {
            AliasHolder comptagenAliasHolder = this.scarabeContext.getComptagenAliasHolder();
            if (comptagenAliasHolder == null) {
                return SimpleResponseHandler.init((String)"Comptagen n'est pas initialis\u00e9");
            }
            try {
                ComptagenEngine comptagenEngine = ComptagenEngine.buildFromRequest((BdfParameters)bdfParameters, this.requestMap, this.scarabeContext);
                return comptagenEngine.run();
            }
            catch (ErrorMessageException eme) {
                return ResponseHandlerFactory.getHtmlInstance((MessageLocalisation)bdfParameters.getMessageLocalisation(), (CommandMessage[])new CommandMessage[]{eme.getErrorMessage()});
            }
        }
        return SimpleResponseHandler.init((String)("Instruction inconnue : " + instruction));
    }
}

