/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.conversion;

import fr.exemole.bdfext.resourcesupdate.api.conversion.Conversion;
import fr.exemole.bdfext.resourcesupdate.api.conversion.ConversionConf;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConversionConfBuilder {
    private final Map<String, Conversion> conversionMap = new LinkedHashMap<String, Conversion>();

    public boolean addConversion(Conversion conversion) {
        String name = conversion.getName();
        if (this.conversionMap.containsKey(name)) {
            return false;
        }
        this.conversionMap.put(name, conversion);
        return true;
    }

    public ConversionConf toConversionConf() {
        Conversion[] conversionArray = this.conversionMap.values().toArray(new Conversion[this.conversionMap.size()]);
        return new InternalConversionConf(conversionArray);
    }

    private static class InternalConversionConf
    implements ConversionConf {
        private final Conversion[] conversionArray;

        private InternalConversionConf(Conversion[] conversionArray) {
            this.conversionArray = conversionArray;
        }

        @Override
        public int getConversionCount() {
            return this.conversionArray.length;
        }

        @Override
        public Conversion getConversion(int index) {
            return this.conversionArray[index];
        }
    }
}

