/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.text.ParseException;
import java.util.function.Consumer;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteursEditor;
import net.desmodo.atlas.descripteurs.ExistingIddescException;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.InvalidContexteException;
import net.desmodo.atlas.xml.api.AtlasDOMErrorHandler;
import net.desmodo.atlas.xml.api.AttributeDOMReader;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class DescripteursDOMReader {
    private final AtlasEditor atlasEditor;
    private final DescripteursEditor descripteursEditor;
    private final AtlasDOMErrorHandler errorHandler;
    private String xpath;
    private final Grille grilledesfamilles;
    private final AttributeDOMReader attributeDOMReader;

    public DescripteursDOMReader(AtlasEditor atlasEditor, AtlasDOMErrorHandler errorHandler) {
        this.atlasEditor = atlasEditor;
        this.descripteursEditor = atlasEditor.getDescripteursEditor();
        this.errorHandler = errorHandler;
        this.attributeDOMReader = new AttributeDOMReader(atlasEditor, errorHandler);
        this.grilledesfamilles = this.descripteursEditor.getDescripteurs().getAtlas().getStructure().getGrilleDesFamilles();
    }

    public void readDescripteursElement(Element element, String xpath) {
        this.xpath = xpath;
        DOMUtils.readChildren((Element)element, (Consumer)new DescripteursConsumer());
    }

    private class DescripteursConsumer
    implements Consumer<Element> {
        private DescripteursConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("infamille")) {
                Contexte famille = null;
                String idctxt = element.getAttribute("idctxt");
                if (idctxt.length() == 0) {
                    DescripteursDOMReader.this.errorHandler.missingAttributeError("idctxt", DescripteursDOMReader.this.xpath + "/infamille");
                } else {
                    famille = DescripteursDOMReader.this.grilledesfamilles.getContexteByIdctxt(idctxt);
                    if (famille == null) {
                        DescripteursDOMReader.this.errorHandler.wrongAttributeError("idctxt", idctxt, "UnknownIdctxt", DescripteursDOMReader.this.xpath + "/infamille");
                    } else if (!famille.isActive()) {
                        DescripteursDOMReader.this.errorHandler.wrongAttributeError("idctxt", idctxt, "InactiveIdctxt", DescripteursDOMReader.this.xpath + "/infamille");
                        famille = null;
                    }
                }
                DOMUtils.readChildren((Element)element, (Consumer)new FamilleConsumer(famille));
            } else if (tagName.equals("sansfamille")) {
                DOMUtils.readChildren((Element)element, (Consumer)new FamilleConsumer(null));
            } else {
                DescripteursDOMReader.this.errorHandler.unknownTagWarning(tagName, DescripteursDOMReader.this.xpath);
            }
        }
    }

    private class DescripteurConsumer
    implements Consumer<Element> {
        private final Descripteur descripteur;
        private final String xp;

        private DescripteurConsumer(Descripteur descripteur, String xpath) {
            this.descripteur = descripteur;
            this.xp = xpath + "/descripteur[@iddesc='" + descripteur.getIddesc().toString() + "']";
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        DescripteursDOMReader.this.atlasEditor.putLibelle(this.descripteur, libelle);
                    }
                }
                catch (ParseException lie) {
                    DescripteursDOMReader.this.errorHandler.libLangAttributeError(element.getAttribute("xml:lang"), this.xp + "/lib");
                }
            } else if (tagName.equals("attr")) {
                String name = element.getAttribute("name");
                if (name.length() > 0) {
                    Attribute attribute = this.getOldAttribute(name, element);
                    if (attribute != null) {
                        DescripteursDOMReader.this.atlasEditor.putAttribute(this.descripteur, attribute);
                    }
                    return;
                }
                DescripteursDOMReader.this.attributeDOMReader.readAttrElement(element, this.descripteur, this.xp);
            } else {
                DescripteursDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
            }
        }

        private Attribute getOldAttribute(String name, Element element) {
            AttributeKey key = null;
            if (name.equals("_url")) {
                key = AtlasAttributes.URL_KEY;
            } else if (name.equals("_poids")) {
                key = AtlasAttributes.POIDS_KEY;
            }
            if (key == null) {
                return null;
            }
            CleanedString cleanedString = CleanedString.newInstance((CharSequence)element.getAttribute("value"));
            if (cleanedString == null) {
                return null;
            }
            return AttributeBuilder.toAttribute((AttributeKey)key, (CleanedString)cleanedString);
        }
    }

    private class FamilleConsumer
    implements Consumer<Element> {
        private final Contexte famille;
        private final String xp;

        private FamilleConsumer(Contexte famille) {
            this.famille = famille;
            this.xp = famille == null ? DescripteursDOMReader.this.xpath + "/sansfamille" : DescripteursDOMReader.this.xpath + "/infamille[@idctxt='" + famille.getIdctxt() + "']";
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("descripteur")) {
                Descripteur descripteur;
                String iddescString = element.getAttribute("iddesc");
                if (iddescString.length() == 0) {
                    DescripteursDOMReader.this.errorHandler.missingAttributeError("iddesc", this.xp + "/descripteur");
                    return;
                }
                Iddesc iddesc = Iddesc.parse(iddescString);
                try {
                    descripteur = DescripteursDOMReader.this.descripteursEditor.createDescripteur(iddesc.getStringPart(), iddesc.getIntPart());
                }
                catch (ExistingIddescException eie) {
                    DescripteursDOMReader.this.errorHandler.wrongAttributeError("iddesc", iddescString, "ExistingIddesc", this.xp + "/descripteur");
                    return;
                }
                if (this.famille != null) {
                    try {
                        DescripteursDOMReader.this.descripteursEditor.setFamille(descripteur, this.famille);
                    }
                    catch (InvalidContexteException ice) {
                        throw new ShouldNotOccurException((Exception)ice);
                    }
                }
                DOMUtils.readChildren((Element)element, (Consumer)new DescripteurConsumer(descripteur, this.xp));
            } else {
                DescripteursDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
            }
        }
    }
}

