/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.ventilation;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienDeduit;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Transversalite;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationName;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.localisation.Lang;

public final class VentilationUtils {
    public static final SecteurList EMPTY_SECTEUR_LIST = new EmptySecteurList();
    public static final LiaisonList EMPTY_LIAISON_LIST = new EmptyLiaisonList();

    private VentilationUtils() {
    }

    public static String getStaticVentilationLocalizedString(Lang lang, VentilationName ventilationName) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("net.desmodo.atlas.ventilation.l10n.defaultventilation", lang.toLocale());
        return resourceBundle.getString(ventilationName.toUriString());
    }

    public static Secteur getFirstActiveSecteur(Ventilation ventilation) {
        SecteurList secteurList = ventilation.getFirstLevelSecteurList();
        int secteurCount = secteurList.getSecteurCount();
        for (int i = 0; i < secteurCount; ++i) {
            Secteur nvsect = secteurList.getSecteur(i);
            if (nvsect.isActive()) {
                return nvsect;
            }
            Secteur nvsect2 = VentilationUtils.getFirstActiveDescendant(nvsect);
            if (nvsect2 == null) continue;
            return nvsect2;
        }
        return null;
    }

    public static Secteur getFirstActiveDescendant(Secteur secteur) {
        SecteurList secteurList = secteur.getChildren();
        int secteurCount = secteurList.getSecteurCount();
        for (int i = 0; i < secteurCount; ++i) {
            Secteur nvsect = secteurList.getSecteur(i);
            if (nvsect.isActive()) {
                return nvsect;
            }
            Secteur nvsect2 = VentilationUtils.getFirstActiveDescendant(nvsect);
            if (nvsect2 == null) continue;
            return nvsect2;
        }
        return null;
    }

    public static SecteurList getBrothers(Secteur secteur) {
        Secteur parent = secteur.getParent();
        if (parent != null) {
            return parent.getChildren();
        }
        return secteur.getVentilation().getFirstLevelSecteurList();
    }

    public static Secteur getFirstChild(Secteur secteur) {
        SecteurList list = secteur.getChildren();
        if (list.getSecteurCount() > 0) {
            return list.getSecteur(0);
        }
        return null;
    }

    public static FirstUncle getFirstUncle(Secteur secteur) {
        Secteur parent = secteur.getParent();
        if (parent == null) {
            return null;
        }
        Secteur grandparent = parent.getParent();
        int index = parent.getIndex();
        if (grandparent == null) {
            SecteurList level0List = parent.getVentilation().getFirstLevelSecteurList();
            if (index < level0List.getSecteurCount() - 1) {
                return new FirstUncle(level0List.getSecteur(index + 1), parent);
            }
            return null;
        }
        SecteurList brothers = grandparent.getChildren();
        if (index < brothers.getSecteurCount() - 1) {
            return new FirstUncle(brothers.getSecteur(index + 1), parent);
        }
        return VentilationUtils.getFirstUncle(parent);
    }

    public static Secteur getParentAt(int profondeur, Secteur secteur) {
        int currentProfondeur;
        if (profondeur < 0 || profondeur > currentProfondeur) {
            throw new IllegalArgumentException("bad profondeur value");
        }
        Secteur parent = secteur;
        for (currentProfondeur = secteur.getProfondeur(); currentProfondeur > profondeur; --currentProfondeur) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static FollowingSecteur getFollowingActiveSecteur(Secteur currentSecteur, int minProfondeur) {
        Secteur descendantSecteur = VentilationUtils.getFirstActiveDescendant(currentSecteur);
        if (descendantSecteur != null) {
            return VentilationUtils.createDescendantFollowingSecteur(currentSecteur, descendantSecteur);
        }
        for (Secteur iteratingSecteur = currentSecteur; iteratingSecteur != null && iteratingSecteur.getProfondeur() >= minProfondeur; iteratingSecteur = iteratingSecteur.getParent()) {
            FollowingSecteur fs = VentilationUtils.getBroherOrNephew(iteratingSecteur);
            if (fs == null) continue;
            fs.currentSecteur = currentSecteur;
            return fs;
        }
        return null;
    }

    public static SecteurList toSecteurList(Collection<Secteur> collection) {
        int size = collection.size();
        if (size == 0) {
            return EMPTY_SECTEUR_LIST;
        }
        return new ArraySecteurList(collection.toArray(new Secteur[size]));
    }

    public static LiaisonList wrapLiaisonList(List<Liaison> list) {
        return new ListLiaisonList(list);
    }

    public static LiaisonList toLiaisonList(Liaison[] array) {
        return new ArrayLiaisonList(array);
    }

    private static FollowingSecteur getBroherOrNephew(Secteur secteur) {
        SecteurList brothers = VentilationUtils.getBrothers(secteur);
        int secteurCount = brothers.getSecteurCount();
        for (int i = secteur.getIndex() + 1; i < secteurCount; ++i) {
            Secteur brother = brothers.getSecteur(i);
            if (brother.isActive()) {
                return VentilationUtils.createBrotherFollowingSecteur(secteur, brother);
            }
            Secteur nephew = VentilationUtils.getFirstActiveDescendant(brother);
            if (nephew == null) continue;
            return VentilationUtils.createNephewFollowingSecteur(secteur, brother, nephew);
        }
        return null;
    }

    private static FollowingSecteur createDescendantFollowingSecteur(Secteur currentSecteur, Secteur descendantSecteur) {
        FollowingSecteur fs = new FollowingSecteur(currentSecteur, descendantSecteur, currentSecteur, currentSecteur, true);
        return fs;
    }

    private static FollowingSecteur createBrotherFollowingSecteur(Secteur currentSecteur, Secteur brotherSecteur) {
        FollowingSecteur fs = new FollowingSecteur(currentSecteur, brotherSecteur, currentSecteur, brotherSecteur, false);
        return fs;
    }

    private static FollowingSecteur createNephewFollowingSecteur(Secteur currentSecteur, Secteur brotherSecteur, Secteur nephewSecteur) {
        FollowingSecteur fs = new FollowingSecteur(currentSecteur, nephewSecteur, currentSecteur, brotherSecteur, false);
        return fs;
    }

    public static String toString(Transversalite transversalite) {
        if (transversalite == null) {
            return "NULL";
        }
        StringBuilder buf = new StringBuilder();
        List<Transversalite.TransversaliteItem> list = transversalite.getTransversaliteItemList();
        buf.append("size = ");
        buf.append(list.size());
        buf.append('\n');
        for (Transversalite.TransversaliteItem item : list) {
            buf.append(item.getLiaison1VentilationCode());
            buf.append(" / ");
            buf.append(item.getLiaison2VentilationCode());
            buf.append(" / ");
            buf.append(item.getTransversaliteType());
            buf.append('\n');
        }
        return buf.toString();
    }

    public static short getLiaisonPosition(Lien lien, Term term) {
        short termType = term.getTermType();
        if (lien instanceof LienSymetrique) {
            return 2;
        }
        if (lien instanceof LienHierarchique) {
            LienHierarchique lh = (LienHierarchique)lien;
            if (lh.getDescripteurPere().equals(term)) {
                return 3;
            }
            return 1;
        }
        if (lien instanceof LienStructurel) {
            if (termType == 1) {
                return 1;
            }
            return 3;
        }
        if (lien instanceof LienDeduit) {
            switch (((LienDeduit)lien).getPosition()) {
                case 3: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
            return 1;
        }
        return 1;
    }

    public static VentilationName getVentilationNaturelle(Term term) {
        if (term == null) {
            return VentilationName.VENTILATION_COMPLETE;
        }
        if (term instanceof Contexte) {
            return VentilationUtils.getContexteVentilationNaturelle((Contexte)term);
        }
        Atlas atlas = term.getAtlas();
        Attribute attribute = term.getAttributes().getAttribute(AtlasAttributes.VENTILATIONNATURELLE_KEY);
        if (attribute != null) {
            try {
                VentilationName ventilationName = VentilationName.parse(attribute.getFirstValue(), atlas);
                return ventilationName;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (term instanceof Descripteur) {
            return VentilationUtils.getContexteVentilationNaturelle(((Descripteur)term).getFamille());
        }
        return VentilationName.VENTILATION_COMPLETE;
    }

    private static VentilationName getContexteVentilationNaturelle(Contexte contexte) {
        Contexte parent;
        Atlas atlas = contexte.getAtlas();
        Attribute attribute = contexte.getAttributes().getAttribute(AtlasAttributes.VENTILATIONNATURELLE_KEY);
        if (attribute != null) {
            try {
                VentilationName ventilationName = VentilationName.parse(attribute.getFirstValue(), atlas);
                return ventilationName;
            }
            catch (ParseException ventilationName) {
                // empty catch block
            }
        }
        if ((parent = contexte.getParent()) != null) {
            return VentilationUtils.getContexteVentilationNaturelle(parent);
        }
        return VentilationUtils.getVentilationNaturelle(contexte.getGrille());
    }

    public static Set<VentilationName> getAuthorizedVentilationNameSet(Term term) {
        if (term == null) {
            return Collections.singleton(VentilationName.VENTILATION_COMPLETE);
        }
        if (term instanceof Contexte) {
            return VentilationUtils.getContexteAuthorizedVentilationNameSet((Contexte)term);
        }
        Atlas atlas = term.getAtlas();
        Attribute attribute = term.getAttributes().getAttribute(AtlasAttributes.VENTILATIONS_KEY);
        if (attribute != null) {
            return VentilationUtils.getAuthorizedVentilationNameSet(attribute, atlas);
        }
        if (term instanceof Descripteur) {
            return VentilationUtils.getContexteAuthorizedVentilationNameSet(((Descripteur)term).getFamille());
        }
        return null;
    }

    private static Set<VentilationName> getContexteAuthorizedVentilationNameSet(Contexte contexte) {
        Attribute attribute = contexte.getAttributes().getAttribute(AtlasAttributes.VENTILATIONS_KEY);
        if (attribute != null) {
            return VentilationUtils.getAuthorizedVentilationNameSet(attribute, contexte.getAtlas());
        }
        Contexte parent = contexte.getParent();
        if (parent != null) {
            return VentilationUtils.getContexteAuthorizedVentilationNameSet(parent);
        }
        return VentilationUtils.getAuthorizedVentilationNameSet(contexte.getGrille());
    }

    private static Set<VentilationName> getAuthorizedVentilationNameSet(Attribute attribute, Atlas atlas) {
        int valueLength = attribute.size();
        HashSet<VentilationName> set = new HashSet<VentilationName>();
        for (int i = 0; i < valueLength; ++i) {
            String value = (String)attribute.get(i);
            if (value.equals("_all")) {
                return null;
            }
            if (value.equals("_none")) {
                return Collections.emptySet();
            }
            try {
                VentilationName ventilationName = VentilationName.parse(value, atlas);
                set.add(ventilationName);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return set;
    }

    public static class FirstUncle {
        private final Secteur firstUncle;
        private final Secteur ancestor;

        FirstUncle(Secteur firstUncle, Secteur ancestor) {
            this.firstUncle = firstUncle;
            this.ancestor = ancestor;
        }

        public Secteur getFirstUncle() {
            return this.firstUncle;
        }

        public Secteur getAncestor() {
            return this.ancestor;
        }
    }

    public static class FollowingSecteur {
        private Secteur currentSecteur;
        private final Secteur followingSecteur;
        private final boolean isDescendant;
        private final Secteur currentSecteurAncestor;
        private final Secteur followingSecteurAncestor;

        private FollowingSecteur(Secteur currentSecteur, Secteur followingSecteur, Secteur currentSecteurAncestor, Secteur followingSecteurAncestor, boolean isDescendant) {
            this.currentSecteur = currentSecteur;
            this.followingSecteur = followingSecteur;
            this.currentSecteurAncestor = currentSecteurAncestor;
            this.followingSecteurAncestor = followingSecteurAncestor;
            this.isDescendant = isDescendant;
        }

        public Secteur getCurrentSecteur() {
            return this.currentSecteur;
        }

        public Secteur getFollowingSecteur() {
            return this.followingSecteur;
        }

        public Secteur getCurrentSecteurAncestor() {
            return this.currentSecteurAncestor;
        }

        public Secteur getFollowingSecteurAncestor() {
            return this.followingSecteurAncestor;
        }

        public boolean isDescendant() {
            return this.isDescendant;
        }
    }

    private static class ArraySecteurList
    implements SecteurList {
        private final Secteur[] array;

        private ArraySecteurList(Secteur[] array) {
            this.array = array;
        }

        @Override
        public int getSecteurCount() {
            return this.array.length;
        }

        @Override
        public Secteur getSecteur(int i) {
            return this.array[i];
        }
    }

    private static class ListLiaisonList
    implements LiaisonList {
        private final List<Liaison> list;

        private ListLiaisonList(List<Liaison> list) {
            this.list = list;
        }

        @Override
        public int getLiaisonCount() {
            return this.list.size();
        }

        @Override
        public Liaison getLiaison(int i) {
            return this.list.get(i);
        }
    }

    private static class ArrayLiaisonList
    implements LiaisonList {
        private final Liaison[] array;

        private ArrayLiaisonList(Liaison[] array) {
            this.array = array;
        }

        @Override
        public int getLiaisonCount() {
            return this.array.length;
        }

        @Override
        public Liaison getLiaison(int i) {
            return this.array[i];
        }
    }

    private static class EmptySecteurList
    implements SecteurList {
        private EmptySecteurList() {
        }

        @Override
        public int getSecteurCount() {
            return 0;
        }

        @Override
        public Secteur getSecteur(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class EmptyLiaisonList
    implements LiaisonList {
        private EmptyLiaisonList() {
        }

        @Override
        public int getLiaisonCount() {
            return 0;
        }

        @Override
        public Liaison getLiaison(int i) {
            throw new IndexOutOfBoundsException();
        }
    }
}

