/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.multilist;

import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.desmodo.atlas.tools.multilist.MultiListItem;
import net.mapeadores.util.primitives.BitmaskUtils;

public final class MultiList {
    private final MultiListItem[][] secondaryArrays;
    private final int[] secondarySizes;
    private final InternalItemList itemPrimaryList = new InternalItemList(-1);
    private final InternalItemList[] itemSecondaryLists;
    private final InternalWrappedObjectList wrappedObjectPrimaryList = new InternalWrappedObjectList(-1);
    private final InternalWrappedObjectList[] wrappedObjectSecondaryLists;
    private MultiListItem[] primaryArray = new MultiListItem[16];
    private int primarySize = 0;

    public MultiList(int secondaryListCount) {
        this.secondaryArrays = new MultiListItem[secondaryListCount][16];
        this.secondarySizes = new int[secondaryListCount];
        this.itemSecondaryLists = new InternalItemList[secondaryListCount];
        this.wrappedObjectSecondaryLists = new InternalWrappedObjectList[secondaryListCount];
        for (int i = 0; i < secondaryListCount; ++i) {
            this.itemSecondaryLists[i] = new InternalItemList(i);
            this.wrappedObjectSecondaryLists[i] = new InternalWrappedObjectList(i);
        }
    }

    public int getPrimarySize() {
        return this.primarySize;
    }

    public int getSecondarySize(int p) {
        return this.secondarySizes[p];
    }

    public int getSecondaryListCount() {
        return this.secondarySizes.length;
    }

    public List<MultiListItem> getItemPrimaryList() {
        return this.itemPrimaryList;
    }

    public List<MultiListItem> getItemSecondaryList(int p) {
        return this.itemSecondaryLists[p];
    }

    public List<Object> getWrappedObjectPrimaryList() {
        return this.wrappedObjectPrimaryList;
    }

    public List<Object> getWrappedObjectSecondaryList(int p) {
        return this.wrappedObjectSecondaryLists[p];
    }

    public void add(MultiListItem multiListItem) {
        if (!multiListItem.isCleared()) {
            throw new IllegalArgumentException("multiListItem is not cleared");
        }
        multiListItem.setMultiList(this);
        if (this.primarySize == this.primaryArray.length) {
            MultiListItem[] ol = new MultiListItem[this.primarySize * 2];
            System.arraycopy(this.primaryArray, 0, ol, 0, this.primarySize);
            this.primaryArray = ol;
        }
        multiListItem.setPrimaryIndex(this.primarySize);
        this.primaryArray[this.primarySize] = multiListItem;
        ++this.primarySize;
        int mask = multiListItem.getMask();
        for (int i = 0; i < this.secondaryArrays.length; ++i) {
            if (BitmaskUtils.booleanValueAt((int)mask, (int)i)) {
                this.addInSecondaryList(multiListItem, i);
                continue;
            }
            multiListItem.setSecondaryIndex(i, -1);
        }
    }

    public void remove(MultiListItem multiListItem) {
        int i;
        int oldindex = multiListItem.getPrimaryIndex();
        int mask = multiListItem.getMask();
        for (i = oldindex + 1; i < this.primarySize; ++i) {
            MultiListItem next;
            this.primaryArray[i - 1] = next = this.primaryArray[i];
            next.decreasePrimaryIndex();
        }
        if (mask > 0) {
            for (i = 0; i < this.secondaryArrays.length; ++i) {
                if (!BitmaskUtils.booleanValueAt((int)mask, (int)i)) continue;
                this.removeInSecondaryList(multiListItem, i, false);
            }
        }
        multiListItem.clear();
        --this.primarySize;
        this.primaryArray[this.primarySize] = null;
    }

    public void removeAllInSecondaryList(int p) {
        InternalItemList list = this.itemSecondaryLists[p];
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            MultiListItem multiListItem = (MultiListItem)list.get(i);
            this.remove(multiListItem);
        }
    }

    public boolean translate(MultiListItem multiListItem, int newIndex) {
        int i;
        if (newIndex < 0 || newIndex >= this.primarySize) {
            throw new IndexOutOfBoundsException(String.valueOf(newIndex));
        }
        int oldIndex = multiListItem.getPrimaryIndex();
        if (oldIndex == newIndex) {
            return false;
        }
        int mask = multiListItem.getMask();
        if (mask > 0) {
            for (int p = 0; p < this.secondaryArrays.length; ++p) {
                if (!BitmaskUtils.booleanValueAt((int)mask, (int)p)) continue;
                int oldidx = multiListItem.getSecondaryIndex(p);
                int nwidx = this.getNewSecondaryIndex(p, oldIndex, newIndex);
                if (nwidx == oldidx) continue;
                this.translateInSecondaryList(multiListItem, p, nwidx);
            }
        }
        if (oldIndex < newIndex) {
            for (i = oldIndex; i < newIndex; ++i) {
                MultiListItem o;
                this.primaryArray[i] = o = this.primaryArray[i + 1];
                o.decreasePrimaryIndex();
            }
        } else {
            for (i = oldIndex; i > newIndex; --i) {
                MultiListItem o;
                this.primaryArray[i] = o = this.primaryArray[i - 1];
                o.increasePrimaryIndex();
            }
        }
        this.primaryArray[newIndex] = multiListItem;
        multiListItem.setPrimaryIndex(newIndex);
        return true;
    }

    public int[] disable(MultiListItem multiListItem, int mask) {
        int[] result = new int[this.secondaryArrays.length];
        for (int p = 0; p < this.secondaryArrays.length; ++p) {
            if (BitmaskUtils.booleanValueAt((int)mask, (int)p)) {
                int oldidx = multiListItem.getSecondaryIndex(p);
                if (oldidx != -1) {
                    this.removeInSecondaryList(multiListItem, p, true);
                    result[p] = oldidx;
                    continue;
                }
                result[p] = -1;
                continue;
            }
            result[p] = -1;
        }
        return result;
    }

    public int[] enable(MultiListItem multiListItem, int mask) {
        int[] result = new int[this.secondaryArrays.length];
        for (int p = 0; p < this.secondaryArrays.length; ++p) {
            if (BitmaskUtils.booleanValueAt((int)mask, (int)p)) {
                int oldidx = multiListItem.getSecondaryIndex(p);
                if (oldidx == -1) {
                    this.enableInSecondaryList(multiListItem, p);
                    result[p] = multiListItem.getSecondaryIndex(p);
                    continue;
                }
                result[p] = -1;
                continue;
            }
            result[p] = -1;
        }
        return result;
    }

    private int getNewSecondaryIndex(int p, int oldIndex, int newIndex) {
        if (oldIndex < newIndex) {
            for (int i = newIndex; i >= oldIndex; --i) {
                MultiListItem o = this.primaryArray[i];
                int idx = o.getSecondaryIndex(p);
                if (idx == -1) continue;
                return idx;
            }
        } else {
            for (int i = newIndex; i <= oldIndex; ++i) {
                MultiListItem o = this.primaryArray[i];
                int idx = o.getSecondaryIndex(p);
                if (idx == -1) continue;
                return idx;
            }
        }
        throw new IllegalStateException("should not occur");
    }

    private void translateInSecondaryList(MultiListItem objectInList, int p, int newIndex) {
        MultiListItem[] array = this.secondaryArrays[p];
        int oldIndex = objectInList.getSecondaryIndex(p);
        if (oldIndex < newIndex) {
            for (int i = oldIndex; i < newIndex; ++i) {
                MultiListItem o;
                array[i] = o = array[i + 1];
                o.decreaseSecondaryIndex(p);
            }
        } else {
            for (int i = oldIndex; i > newIndex; --i) {
                MultiListItem o;
                array[i] = o = array[i - 1];
                o.increaseSecondaryIndex(p);
            }
        }
        array[newIndex] = objectInList;
        objectInList.setSecondaryIndex(p, newIndex);
    }

    private void addInSecondaryList(MultiListItem objectInList, int p) {
        int size = this.secondarySizes[p];
        MultiListItem[] array = this.secondaryArrays[p];
        if (size == array.length) {
            MultiListItem[] ol = new MultiListItem[size * 2];
            System.arraycopy(array, 0, ol, 0, size);
            array = ol;
            this.secondaryArrays[p] = array;
        }
        array[size] = objectInList;
        objectInList.setSecondaryIndex(p, size);
        int n = p;
        this.secondarySizes[n] = this.secondarySizes[n] + 1;
    }

    private void removeInSecondaryList(MultiListItem objectInList, int p, boolean maskchange) {
        int oldindex = objectInList.getSecondaryIndex(p);
        if (oldindex == -1) {
            throw new IllegalStateException("should not occur");
        }
        MultiListItem[] array = this.secondaryArrays[p];
        int size = this.secondarySizes[p];
        for (int i = oldindex + 1; i < size; ++i) {
            MultiListItem next;
            array[i - 1] = next = array[i];
            next.decreaseSecondaryIndex(p);
        }
        if (maskchange) {
            objectInList.setSecondaryIndex(p, -1);
        }
        int n = p;
        this.secondarySizes[n] = this.secondarySizes[n] - 1;
        array[size - 1] = null;
    }

    private void enableInSecondaryList(MultiListItem multiListItem, int p) {
        int i;
        MultiListItem[] array = this.secondaryArrays[p];
        int secondarySize = this.secondarySizes[p];
        int primaryIndex = multiListItem.getPrimaryIndex();
        int newSecondaryIndex = 0;
        for (i = 0; i < secondarySize && array[i].getPrimaryIndex() < primaryIndex; ++i) {
            ++newSecondaryIndex;
        }
        if (secondarySize == array.length) {
            MultiListItem[] ol = new MultiListItem[secondarySize * 2];
            System.arraycopy(array, 0, ol, 0, secondarySize);
            array = ol;
            this.secondaryArrays[p] = array;
        }
        if (newSecondaryIndex < secondarySize) {
            for (i = secondarySize; i > newSecondaryIndex; --i) {
                MultiListItem previous;
                array[i] = previous = array[i - 1];
                previous.increaseSecondaryIndex(p);
            }
        }
        array[newSecondaryIndex] = multiListItem;
        multiListItem.setSecondaryIndex(p, newSecondaryIndex);
        int n = p;
        this.secondarySizes[n] = this.secondarySizes[n] + 1;
    }

    private class InternalItemList
    extends AbstractList<MultiListItem>
    implements RandomAccess {
        private final int listIndex;

        InternalItemList(int listIndex) {
            this.listIndex = listIndex;
        }

        @Override
        public int size() {
            if (this.listIndex == -1) {
                return MultiList.this.primarySize;
            }
            return MultiList.this.secondarySizes[this.listIndex];
        }

        @Override
        public MultiListItem get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0");
            }
            if (this.listIndex == -1) {
                if (index >= MultiList.this.primarySize) {
                    throw new IndexOutOfBoundsException("index >= size()");
                }
                return MultiList.this.primaryArray[index];
            }
            if (index >= MultiList.this.secondarySizes[this.listIndex]) {
                throw new IndexOutOfBoundsException("index >= size()");
            }
            return MultiList.this.secondaryArrays[this.listIndex][index];
        }
    }

    private class InternalWrappedObjectList
    extends AbstractList<Object>
    implements RandomAccess {
        private final int listIndex;

        InternalWrappedObjectList(int listIndex) {
            this.listIndex = listIndex;
        }

        @Override
        public int size() {
            if (this.listIndex == -1) {
                return MultiList.this.primarySize;
            }
            return MultiList.this.secondarySizes[this.listIndex];
        }

        @Override
        public Object get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0");
            }
            if (this.listIndex == -1) {
                if (index >= MultiList.this.primarySize) {
                    throw new IndexOutOfBoundsException("index >= size()");
                }
                return MultiList.this.primaryArray[index].getWrappedObject();
            }
            if (index >= MultiList.this.secondarySizes[this.listIndex]) {
                throw new IndexOutOfBoundsException("index >= size()");
            }
            return MultiList.this.secondaryArrays[this.listIndex][index].getWrappedObject();
        }
    }
}

