/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.structure;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;

public class StructureUtils {
    public static final ContexteList EMPTY_CONTEXTE_LIST = new EmptyContexteList();
    public static final GrilleList EMPTY_GRILLE_LIST = new EmptyGrilleList();

    private StructureUtils() {
    }

    public static boolean isGrilleDesFamilles(Grille grille) {
        return grille.getGrilleName().length() == 0;
    }

    public static int getFirstLevelCount(Grille grille) {
        return grille.getFirstLevelContexteList().getContexteCount();
    }

    public static boolean isHorsgrilleContexte(Contexte contexte) {
        return contexte.getGrille() == null;
    }

    public static Contexte getHorsgrilleContexte(Structure structure) {
        return structure.getSpecialContexte((short)5);
    }

    public static boolean isSansfamilleContexte(Contexte contexte) {
        if (contexte.getIdctxt().length() != 0) {
            return false;
        }
        Grille grille = contexte.getGrille();
        return grille != null;
    }

    public static Contexte getSansfamilleContexte(Structure structure) {
        return structure.getSpecialContexte((short)6);
    }

    public static boolean isFamille(Contexte contexte) {
        if (contexte.getIdctxt().length() == 0) {
            return false;
        }
        return contexte.getGrille().getGrilleName().length() == 0;
    }

    public static boolean isFamilleOrSansfamille(Contexte contexte) {
        Grille grille = contexte.getGrille();
        if (grille == null) {
            return false;
        }
        return grille.getGrilleName().length() == 0;
    }

    public static boolean isSpecialContexte(Contexte contexte) {
        return contexte.getIdctxt().length() == 0;
    }

    public static boolean isHorsgrilleOrInGrilleContexte(Contexte contexte) {
        Grille grille = contexte.getGrille();
        if (grille == null) {
            return true;
        }
        return grille.getGrilleName().length() > 0;
    }

    public static Contexte getContexte(Structure structure, String grilleName, String idctxt) {
        Grille grille = structure.getGrille(grilleName);
        if (grille == null) {
            return null;
        }
        return grille.getContexteByIdctxt(idctxt);
    }

    public static int checkValidity(String idctxt) {
        if (idctxt == null) {
            return -1;
        }
        if (idctxt.length() == 0) {
            return -2;
        }
        if (!idctxt.trim().equals(idctxt)) {
            return -3;
        }
        return 1;
    }

    public static boolean hasChildren(Contexte contexte) {
        return contexte.getChildren().getContexteCount() == 0;
    }

    public static boolean hasParent(Contexte contexte) {
        return contexte.getParent() != null;
    }

    public static ContexteList getContexteList(Grille grille, boolean parentOnly) {
        ContexteList firstlevel = grille.getFirstLevelContexteList();
        ArrayList<Contexte> liste = new ArrayList<Contexte>();
        StructureUtils.addContexte(firstlevel, liste, parentOnly);
        return new ArrayListContexteList(liste);
    }

    public static ContexteList toContexteList(Contexte[] array) {
        return new ArrayContexteList(array);
    }

    public static GrilleList toGrilleList(Grille[] array) {
        return new ArrayGrilleList(array);
    }

    public static ContexteList getFamilleList(Structure structure, boolean parentOnly) {
        return StructureUtils.getContexteList(structure.getGrilleDesFamilles(), parentOnly);
    }

    private static void addContexte(ContexteList origine, List<Contexte> destination, boolean parentOnly) {
        int origineContexteCount = origine.getContexteCount();
        for (int i = 0; i < origineContexteCount; ++i) {
            Contexte contexte = origine.getContexte(i);
            ContexteList children = contexte.getChildren();
            if (children.getContexteCount() == 0) {
                if (parentOnly) continue;
                destination.add(contexte);
                continue;
            }
            destination.add(contexte);
            StructureUtils.addContexte(children, destination, parentOnly);
        }
    }

    public static int getProfondeur(Contexte contexte) {
        Contexte parent = contexte.getParent();
        if (parent == null) {
            return 0;
        }
        return StructureUtils.getProfondeur(parent) + 1;
    }

    public static Color getParentColor(Contexte contexte) {
        Contexte parent = contexte.getParent();
        if (parent == null) {
            return AtlasAttributes.getColor(contexte.getGrille());
        }
        return AtlasAttributes.getColor(parent);
    }

    private static class ArrayListContexteList
    implements ContexteList {
        private final ArrayList<Contexte> arrayList;

        private ArrayListContexteList(ArrayList<Contexte> arrayList) {
            this.arrayList = arrayList;
        }

        @Override
        public int getContexteCount() {
            return this.arrayList.size();
        }

        @Override
        public Contexte getContexte(int i) {
            return this.arrayList.get(i);
        }
    }

    private static class ArrayContexteList
    implements ContexteList {
        private final Contexte[] array;

        private ArrayContexteList(Contexte[] array) {
            this.array = array;
        }

        @Override
        public int getContexteCount() {
            return this.array.length;
        }

        @Override
        public Contexte getContexte(int i) {
            return this.array[i];
        }
    }

    private static class ArrayGrilleList
    implements GrilleList {
        private final Grille[] array;

        private ArrayGrilleList(Grille[] array) {
            this.array = array;
        }

        @Override
        public int getGrilleCount() {
            return this.array.length;
        }

        @Override
        public Grille getGrille(int i) {
            return this.array[i];
        }
    }

    private static class EmptyContexteList
    implements ContexteList {
        private EmptyContexteList() {
        }

        @Override
        public int getContexteCount() {
            return 0;
        }

        @Override
        public Contexte getContexte(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class EmptyGrilleList
    implements GrilleList {
        private EmptyGrilleList() {
        }

        @Override
        public int getGrilleCount() {
            return 0;
        }

        @Override
        public Grille getGrille(int i) {
            throw new IndexOutOfBoundsException();
        }
    }
}

