/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.components.HighlightBorder;
import net.desmodo.atlas.display.overflow.Overflow;

public class HighlightComponent
extends JComponent {
    public HighlightComponent(Color highlightColor) {
        this.setOpaque(false);
        this.setBorder(new HighlightBorder(highlightColor));
    }

    public HighlightComponent(Border border) {
        this.setOpaque(false);
        this.setBorder(border);
    }

    public void setLibelleBlock(LibelleBlock libelleBlock, Overflow overflow) {
        if (libelleBlock == null) {
            this.setVisible(false);
        } else {
            Rectangle rect = this.redimBorder(libelleBlock.getTextBox().getDimension(), libelleBlock.getLocation());
            this.setSize(rect.width, rect.height);
            this.setLocation(rect.x + overflow.getWestOverflow(), rect.y + overflow.getNorthOverflow());
            this.setVisible(true);
        }
    }

    Rectangle redimBorder(Dimension dim, Point P) {
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : this.getInsets();
        Dimension newdim = new Dimension(dim.width + insets.left + insets.right, dim.height + insets.top + insets.bottom);
        Point newpoint = new Point(P.x - insets.left, P.y - insets.top);
        return new Rectangle(newpoint, newdim);
    }
}

