/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.edition;

import fr.exemole.bdfext.desmography.api.AtlasEdition;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;

public class AtlasEditionBuilder {
    private final List<AtlasEdition.EditionUnit> unitList = new ArrayList<AtlasEdition.EditionUnit>();
    private final Map<Motcle, AtlasEdition.TermRemove> termRemoveMap = new LinkedHashMap<Motcle, AtlasEdition.TermRemove>();
    private String confirmationWord;

    public void setConfirmationWord(String confirmationWord) {
        this.confirmationWord = confirmationWord;
    }

    public void addFamilyRemove(Motcle term, Motcle family) {
        this.unitList.add(new InternalFamilyRemove(term, family));
    }

    public void addFamilyAdd(Motcle term, Motcle family) {
        this.unitList.add(new InternalFamilyAdd(term, family));
    }

    public void addTermRemove(Motcle term) {
        this.termRemoveMap.put(term, new InternalTermRemove(term));
    }

    public void addTermMerge(Motcle term, Motcle destinationTerm) {
        this.unitList.add(new InternalTermMerge(term, destinationTerm));
    }

    public void addInferiorsRemove(FicheMeta relation, Collection<Motcle> inferiors) {
        this.unitList.add(new InternalInferiorsRemove(relation, inferiors));
    }

    public void addHierachyAdd(Motcle superior, Motcle inferior, Collection<Motcle> sectors) {
        this.unitList.add(new InternalHierarchyAdd(Collections.singleton(superior), Collections.singleton(inferior), sectors));
    }

    public void addHierachyAdd(Collection<Motcle> superiors, Collection<Motcle> inferiors, Collection<Motcle> sectors) {
        this.unitList.add(new InternalHierarchyAdd(superiors, inferiors, sectors));
    }

    public void add(AtlasEdition.EditionUnit editionUnit) {
        if (editionUnit instanceof AtlasEdition.TermRemove) {
            AtlasEdition.TermRemove termRemove = (AtlasEdition.TermRemove)editionUnit;
            this.termRemoveMap.put(termRemove.getTerm(), termRemove);
        } else {
            this.unitList.add(editionUnit);
        }
    }

    public AtlasEdition toAtlasEdition() {
        this.unitList.addAll(this.termRemoveMap.values());
        return new InternalAtlasEdition(this.confirmationWord, new EditionUnitList(this.unitList.toArray(new AtlasEdition.EditionUnit[this.unitList.size()])));
    }

    private static class InternalFamilyRemove
    implements AtlasEdition.FamilyRemove {
        private final Motcle term;
        private final Motcle family;

        private InternalFamilyRemove(Motcle term, Motcle family) {
            this.term = term;
            this.family = family;
        }

        @Override
        public Motcle getTerm() {
            return this.term;
        }

        @Override
        public Motcle getFamily() {
            return this.family;
        }
    }

    private static class InternalFamilyAdd
    implements AtlasEdition.FamilyAdd {
        private final Motcle term;
        private final Motcle family;

        private InternalFamilyAdd(Motcle term, Motcle family) {
            this.term = term;
            this.family = family;
        }

        @Override
        public Motcle getTerm() {
            return this.term;
        }

        @Override
        public Motcle getFamily() {
            return this.family;
        }
    }

    private static class InternalTermRemove
    implements AtlasEdition.TermRemove {
        private final Motcle term;

        private InternalTermRemove(Motcle term) {
            this.term = term;
        }

        @Override
        public Motcle getTerm() {
            return this.term;
        }
    }

    private static class InternalTermMerge
    implements AtlasEdition.TermMerge {
        private final Motcle term;
        private final Motcle destinationTerm;

        private InternalTermMerge(Motcle term, Motcle destinationTerm) {
            this.term = term;
            this.destinationTerm = destinationTerm;
        }

        @Override
        public Motcle getTerm() {
            return this.term;
        }

        @Override
        public Motcle getDestinationTerm() {
            return this.destinationTerm;
        }
    }

    private static class InternalInferiorsRemove
    implements AtlasEdition.InferiorsRemove {
        private final FicheMeta relation;
        private final Collection<Motcle> inferiors;

        private InternalInferiorsRemove(FicheMeta relation, Collection<Motcle> inferiors) {
            this.relation = relation;
            this.inferiors = inferiors;
        }

        @Override
        public FicheMeta getRelation() {
            return this.relation;
        }

        @Override
        public Collection<Motcle> getInferiors() {
            return this.inferiors;
        }
    }

    private static class InternalHierarchyAdd
    implements AtlasEdition.HierarchyAdd {
        private final Collection<Motcle> superiors;
        private final Collection<Motcle> inferiors;
        private final Collection<Motcle> sectors;

        private InternalHierarchyAdd(Collection<Motcle> superiors, Collection<Motcle> inferiors, Collection<Motcle> sectors) {
            this.superiors = superiors;
            this.inferiors = inferiors;
            this.sectors = sectors;
        }

        @Override
        public Collection<Motcle> getSuperiors() {
            return this.superiors;
        }

        @Override
        public Collection<Motcle> getInferiors() {
            return this.inferiors;
        }

        @Override
        public Collection<Motcle> getSectors() {
            return this.sectors;
        }
    }

    private static class InternalAtlasEdition
    implements AtlasEdition {
        private final String confirmationWord;
        private final List<AtlasEdition.EditionUnit> editionUnitList;

        private InternalAtlasEdition(String confirmationWord, List<AtlasEdition.EditionUnit> editionUnitList) {
            this.confirmationWord = confirmationWord;
            this.editionUnitList = editionUnitList;
        }

        @Override
        public String getConfirmationWord() {
            return this.confirmationWord;
        }

        @Override
        public List<AtlasEdition.EditionUnit> getEditionUnitList() {
            return this.editionUnitList;
        }
    }

    private static class EditionUnitList
    extends AbstractList<AtlasEdition.EditionUnit>
    implements RandomAccess {
        private final AtlasEdition.EditionUnit[] array;

        private EditionUnitList(AtlasEdition.EditionUnit[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AtlasEdition.EditionUnit get(int index) {
            return this.array[index];
        }
    }
}

