/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.api.AtlasEdition;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.atlas.engines.AtlasEditionEngine;
import fr.exemole.bdfext.desmography.atlas.engines.AtlasEditionReport;
import fr.exemole.bdfext.desmography.dsmd.DsmdXmlProducer;
import fr.exemole.bdfext.desmography.edition.AtlasEditionBuilder;
import fr.exemole.bdfext.desmography.edition.AtlasEditionDOMReader;
import fr.exemole.bdfext.desmography.producers.json.EditionJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.ErrorJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.ApiJsonProducerFactory;
import fr.exemole.bdfext.desmography.sync.SyncXmlProducer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.docstream.VersionDocStream;
import fr.exemole.bdfserver.tools.instruction.AnonymousRequestHandler;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import net.fichotheque.Subset;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SourceLogsBuilder;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.regex.RegexList;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.DocStreamResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.XmlResponseHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XmlProducer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DesmographyBdfInstructionProvider
implements BdfInstructionProvider {
    private static final RegexList regexList;

    public BdfInstruction getBdfInstruction(BdfServer bdfServer, String extensionPath, RequestMap requestMap) {
        String type;
        Map map = regexList.getMap(extensionPath);
        if (map == null) {
            return null;
        }
        AnonymousRequestHandler requestHandler = AnonymousRequestHandler.init((BdfServer)bdfServer, (RequestMap)requestMap);
        switch (type = (String)map.get("type")) {
            case "json": {
                return new JsonBdfInstruction(bdfServer, requestMap);
            }
            case "edition": {
                return new EditionBdfInstruction(bdfServer, requestMap);
            }
            case "export": {
                Lang lang;
                String name = (String)map.get("name");
                if (name == null) {
                    return null;
                }
                String langString = (String)map.get("lang");
                if (langString == null) {
                    return null;
                }
                try {
                    lang = Lang.parse((String)langString);
                }
                catch (ParseException pe) {
                    return null;
                }
                try {
                    Atlas atlas = DesmographyUtils.getAtlas(bdfServer, name);
                    return new ExportBdfInstruction(atlas, lang);
                }
                catch (ErrorMessageException eme) {
                    return null;
                }
            }
            case "download": {
                Version version = DesmographyBdfInstructionProvider.getVersion(requestHandler);
                if (version != null) {
                    return new DownloadBdfInstruction(bdfServer, version);
                }
                return null;
            }
            case "sync": {
                String name = (String)map.get("name");
                if (name == null) {
                    return null;
                }
                try {
                    Atlas atlas = DesmographyUtils.getAtlas(bdfServer, name);
                    return new SyncBdfInstruction(atlas);
                }
                catch (ErrorMessageException eme) {
                    return null;
                }
            }
        }
        return null;
    }

    private static Version getVersion(AnonymousRequestHandler requestHandler) {
        try {
            Document document = requestHandler.getMandatoryDocument();
            String extension = requestHandler.getMandatoryParameter("extension");
            return document.getVersionByExtension(extension);
        }
        catch (ErrorMessageException bie) {
            return null;
        }
    }

    static {
        try {
            String s = IOUtils.toString((InputStream)DesmographyBdfInstructionProvider.class.getResourceAsStream("regex.txt"), (String)"UTF-8");
            regexList = RegexList.parse((String)s);
        }
        catch (IOException ioe) {
            throw new InternalResourceException((Exception)ioe);
        }
    }

    private static class JsonBdfInstruction
    implements BdfInstruction {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;

        private JsonBdfInstruction(BdfServer bdfServer, RequestMap requestMap) {
            this.requestMap = requestMap;
            this.bdfServer = bdfServer;
        }

        public short getBdfUserNeed() {
            return 2;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            JsonProducer jsonProducer = ApiJsonProducerFactory.getJsonProducer(this.bdfServer, this.requestMap, bdfUser);
            return JsonResponseHandler.build((JsonProducer)jsonProducer, (RequestMap)this.requestMap).giveAccess(this.requestMap);
        }
    }

    private static class EditionBdfInstruction
    implements BdfInstruction {
        private final BdfServer bdfServer;
        private final RequestMap requestMap;

        private EditionBdfInstruction(BdfServer bdfServer, RequestMap requestMap) {
            this.requestMap = requestMap;
            this.bdfServer = bdfServer;
        }

        public short getBdfUserNeed() {
            return 2;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            JsonProducer jsonProducer;
            try {
                jsonProducer = this.run(bdfUser);
            }
            catch (ErrorMessageException eme) {
                MessageLocalisation messageLocalisation = BdfInstructionUtils.getMessageLocalisation((RequestMap)this.requestMap, (BdfServer)this.bdfServer, (UserLangContext)bdfUser);
                jsonProducer = new ErrorJsonProducer(eme.getErrorMessage(), messageLocalisation);
            }
            return JsonResponseHandler.build((JsonProducer)jsonProducer, (RequestMap)this.requestMap).giveAccess(this.requestMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JsonProducer run(BdfUser bdfUser) throws ErrorMessageException {
            AtlasEditionReport atlasEditionReport;
            org.w3c.dom.Document document;
            if (bdfUser == null) {
                throw new ErrorMessageException("_ warning.session.expiredsession");
            }
            DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
            PermissionChecker permissionChecker = PermissionChecker.init((BdfParameters)bdfParameters);
            String desmographyName = DesmographyUtils.getMandatoryValue(this.requestMap, "desmography");
            String xml = DesmographyUtils.getMandatoryValue(this.requestMap, "xml");
            Atlas atlas = DesmographyUtils.getAtlas(this.bdfServer, desmographyName);
            permissionChecker.checkSubsetAdmin((Subset)atlas.getTermThesaurus());
            DocumentBuilder documentBuilder = DOMUtils.newDocumentBuilder();
            try {
                document = documentBuilder.parse(new InputSource(new StringReader(xml)));
            }
            catch (SAXException saxe) {
                throw new ErrorMessageException("_ error.exception.xml.sax", new Object[]{"xml", saxe.getLocalizedMessage()});
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException();
            }
            SourceLogsBuilder logsBuilder = new SourceLogsBuilder();
            EditionJsonProducer editionJsonProducer = new EditionJsonProducer(atlas, bdfUser.getWorkingLang(), bdfParameters.getMessageLocalisation());
            AtlasEditionBuilder atlasEditionBuilder = new AtlasEditionBuilder();
            logsBuilder.setCurrentSource("XmlParse");
            AtlasEditionDOMReader.init(atlasEditionBuilder, atlas, (MessageHandler)logsBuilder).read(document.getDocumentElement());
            AtlasEdition atlasEdition = atlasEditionBuilder.toAtlasEdition();
            if (AtlasEditionEngine.needConfirmation(atlasEdition)) {
                String confirmationWord = atlasEdition.getConfirmationWord();
                if (confirmationWord == null) {
                    throw new ErrorMessageException("_ error.empty.xml.attribute", new Object[]{"confirmation-word", "edition"});
                }
                String atlasConfirmationWord = AtlasUtils.getConfirmationWord(atlas);
                if (atlasConfirmationWord == null) {
                    throw new ErrorMessageException("_ error.unknown.xml.attributevalue", new Object[]{"***", "edition", "confirmation-word"});
                }
                if (!confirmationWord.equals(atlasConfirmationWord)) {
                    throw new ErrorMessageException("_ error.wrong.xml.attributevalue", new Object[]{"***", "edition", "confirmation-word"});
                }
            }
            BdfServer bdfServer = this.bdfServer;
            synchronized (bdfServer) {
                try (EditSession editSession = this.bdfServer.initEditSession(bdfUser, "ext:Desmography");){
                    logsBuilder.setCurrentSource("EditionEngine");
                    AtlasEditionEngine engine = new AtlasEditionEngine(atlas, (BdfParameters)bdfParameters, editSession.getFichothequeEditor(), (MessageHandler)logsBuilder);
                    atlasEditionReport = engine.runEdition(atlasEdition);
                }
            }
            editionJsonProducer.setEditionLogs(logsBuilder.toSourceLogs());
            editionJsonProducer.setReport(atlasEditionReport);
            return editionJsonProducer;
        }
    }

    private static class ExportBdfInstruction
    implements BdfInstruction {
        private final Atlas atlas;
        private final Lang lang;

        private ExportBdfInstruction(Atlas atlas, Lang lang) {
            this.atlas = atlas;
            this.lang = lang;
        }

        public short getBdfUserNeed() {
            return 1;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            return XmlResponseHandler.init((XmlProducer)new DsmdXmlProducer(this.atlas, this.lang), (String)"application/x-desmodo");
        }
    }

    private static class DownloadBdfInstruction
    implements BdfInstruction {
        private final BdfServer bdfServer;
        private final Version version;

        private DownloadBdfInstruction(BdfServer bdfServer, Version version) {
            this.bdfServer = bdfServer;
            this.version = version;
        }

        public short getBdfUserNeed() {
            return 1;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            MimeTypeResolver mimeTypeResolver = this.bdfServer.getMimeTypeResolver();
            String mimeType = MimeTypeUtils.getMimeType((MimeTypeResolver)mimeTypeResolver, (String)this.version.getFileName());
            String charset = MimeTypeUtils.getDefaultCharset((String)mimeType);
            StringBuilder buf = new StringBuilder();
            buf.append(this.version.getDocument().getBasename());
            buf.append(".");
            buf.append(this.version.getExtension());
            return DocStreamResponseHandler.init((DocStream)new VersionDocStream(this.version, mimeType, charset)).fileName(buf.toString());
        }
    }

    private static class SyncBdfInstruction
    implements BdfInstruction {
        private final Atlas atlas;

        private SyncBdfInstruction(Atlas atlas) {
            this.atlas = atlas;
        }

        public short getBdfUserNeed() {
            return 1;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            return XmlResponseHandler.init((XmlProducer)new SyncXmlProducer(this.atlas));
        }
    }
}

