/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.annuaire.commands;

import fr.exemole.bdfext.annuaire.commands.FieldKeyMap;
import fr.exemole.bdfext.annuaire.commands.KeyArrays;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.request.RequestMap;

public class Recherche {
    private final RequestMap requestMap;
    private final BdfParameters bdfParameters;
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final SubsetKey corpusKey = SubsetKey.build((String)"corpus_personne");
    private final Fichotheque fichotheque;
    private final FieldKeyMap fieldKeyMap;
    private final Lang workingLang;
    private final Corpus corpus;
    private final SubsetKey[] corpusKeyArray = new SubsetKey[]{this.corpusKey};

    public Recherche(BdfParameters bdfParameters, RequestMap requestMap, FieldKeyMap fieldKeyMap) {
        this.requestMap = requestMap;
        this.bdfParameters = bdfParameters;
        this.bdfServer = bdfParameters.getBdfServer();
        this.bdfUser = bdfParameters.getBdfUser();
        this.fichotheque = this.bdfServer.getFichotheque();
        this.corpus = (Corpus)this.fichotheque.getSubset(this.corpusKey);
        this.fieldKeyMap = fieldKeyMap;
        this.workingLang = this.bdfUser.getWorkingLang();
    }

    public void run() {
        Set set = this.requestMap.getParameterNameSet();
        ArrayList<FicheSelector> ficheSelectUnitList = new ArrayList<FicheSelector>();
        for (String paramName : set) {
            String value;
            TextCondition condition;
            KeyArrays keyArrays = this.fieldKeyMap.getKeyArrays(paramName);
            if (keyArrays == null || (condition = ConditionsUtils.parseSimpleCondition((String)(value = this.requestMap.getParameter(paramName)))) == null) continue;
            List<FicheQuery> ficheQueryList = this.toFicheQueryList(condition, keyArrays);
            SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder((BdfServer)this.bdfServer, (Lang)this.workingLang).setSubsetAccessPredicate(this.bdfParameters.getPermissionSummary().getSubsetAccessPredicate()).toSelectionContext();
            FicheSelectorBuilder builder = FicheSelectorBuilder.init((SelectionContext)selectionContext);
            for (FicheQuery ficheQuery : ficheQueryList) {
                builder.add(ficheQuery);
            }
            ficheSelectUnitList.add(builder.toFicheSelector());
        }
        FichesBuilder fichesBuilder = FichesBuilder.build((String)"title-asc", (Lang)this.workingLang).initSubsetKeyOrder(TreeUtils.getCorpusKeyList((BdfServer)this.bdfServer));
        int size = ficheSelectUnitList.size();
        if (size > 0) {
            FicheSelector[] array = ficheSelectUnitList.toArray(new FicheSelector[size]);
            for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
                boolean absent = false;
                for (int j = 0; j < size; ++j) {
                    if (array[j].test((Object)ficheMeta)) continue;
                    absent = true;
                    break;
                }
                if (absent) continue;
                fichesBuilder.add(ficheMeta);
            }
        }
        this.bdfServer.getSelectionManager().setCustomSelectedFiches(this.bdfUser, fichesBuilder.toFiches());
    }

    private List<FicheQuery> toFicheQueryList(TextCondition condition, KeyArrays keyArrays) {
        SubsetKey[] thesaurusKeyArray;
        ArrayList<FicheQuery> list = new ArrayList<FicheQuery>();
        List<FieldKey> fieldKeyList = keyArrays.getFieldKeyList();
        if (fieldKeyList != null) {
            FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus((Object)this.corpusKeyArray).setFieldContentCondition(condition, "selection", fieldKeyList).toFicheQuery();
            list.add(ficheQuery);
        }
        if ((thesaurusKeyArray = keyArrays.getThesaurusKeyArray()) != null) {
            MotcleQuery motcleQuery = MotcleQueryBuilder.init().addThesaurus((Object)thesaurusKeyArray).setContentCondition(condition, "idalpha_with").toMotcleQuery();
            FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus((Object)this.corpusKeyArray).addMotcleConditionEntry(SelectionUtils.toMotcleConditionEntry((MotcleQuery)motcleQuery)).toFicheQuery();
            list.add(ficheQuery);
        }
        return list;
    }
}

