/* UtilLib - Copyright (c) 2015-2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.logging;

import java.io.IOException;
import java.util.List;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;


/**
 *
 * @author Vincent Calame
 */
public class SourceLogXMLPart extends XMLPart {

    public SourceLogXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addLogs(SourceLogs logs) throws IOException {
        openTag("logs");
        for (SourceLog log : logs) {
            addLog(log);
        }
        closeTag("logs");
    }

    public void addLog(SourceLog log) throws IOException {
        String name = log.getName();
        startOpenTag("log");
        addAttribute("name", name);
        addAttribute("uri", name);
        endOpenTag();
        for (SourceMessage sourceMessage : log.getSourceMessageList()) {
            addMessage(sourceMessage);
        }
        closeTag("log");
    }

    private void addMessage(SourceMessage sourceMessage) throws IOException {
        startOpenTag("message");
        addAttribute("category", sourceMessage.getCategory());
        addAttribute("key", sourceMessage.getMessageKey());
        List<Object> valueList = sourceMessage.getMessageValueList();
        if (valueList.isEmpty()) {
            closeEmptyTag();
        } else {
            endOpenTag();
            for (Object val : valueList) {
                addSimpleElement("value", val.toString());
            }
            closeTag("message");
        }
    }

}
