/* UtilLib - Copyright (c) 2022-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.jslib;

import net.mapeadores.util.text.RelativePath;


/**
 *
 * @author Vincent Calame
 */
public class TemplateFamilyBuilder {

    private final String name;
    private RelativePath path = null;

    public TemplateFamilyBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public TemplateFamilyBuilder setPath(RelativePath path) {
        this.path = path;
        return this;
    }

    public TemplateFamily toTemplateFamily() {
        RelativePath finalPath = path;
        if (finalPath == null) {
            finalPath = RelativePath.build("templates/" + name);
        }
        return new InternalTemplateFamily(name, finalPath);
    }

    public static TemplateFamilyBuilder init(String name) {
        return new TemplateFamilyBuilder(name);
    }

    public static TemplateFamilyBuilder init(String name, RelativePath path) {
        return new TemplateFamilyBuilder(name);
    }


    private static class InternalTemplateFamily implements TemplateFamily {

        private final String name;
        private final RelativePath path;

        private InternalTemplateFamily(String name, RelativePath path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public RelativePath getPath() {
            return path;
        }

    }

}
