/* FichothequeLib_Xml - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.xml.storage;

import java.io.IOException;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Tie;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;


/**
 *
 * @author Vincent Calame
 */
public class JunctionStorageXMLPart extends XMLPart {

    public JunctionStorageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendJunction(Junction junction) throws IOException {
        openTag("junction");
        for (Tie tie : junction.getTieList()) {
            startOpenTag("tie");
            addAttribute("mode", tie.getMode());
            addAttribute("weight", tie.getWeight());
            addAttribute("position1", tie.getPosition1());
            addAttribute("position2", tie.getPosition2());
            closeEmptyTag();
        }
        AttributeUtils.addAttributes(this, junction.getAttributes());
        closeTag("junction");
    }

}
