/* FichothequeLib_Xml - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.xml.extraction;

import net.fichotheque.SubsetKey;
import net.fichotheque.extraction.ExtractionConstants;
import net.mapeadores.util.exceptions.SwitchException;


/**
 *
 * @author Vincent Calame
 */
public class TagNames {

    private final int extractVersion;

    public TagNames(int extractVersion) {
        this.extractVersion = extractVersion;
    }

    public String getTitleTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "titre";
        } else {
            return "title";
        }
    }

    public String getSubtitleTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "soustitre";
        } else {
            return "subtitle";
        }
    }

    public String getOwnersTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "redacteurs";
        } else {
            return "owners";
        }
    }

    public String getPropTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "propriete";
        } else {
            return "prop";
        }
    }

    public String getInfoTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "information";
        } else {
            return "info";
        }
    }

    public String getTieTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "lien";
        } else {
            return "tie";
        }
    }

    public String getSubsetTagName(short subsetCategory) {
        switch (extractVersion) {
            case ExtractionConstants.INITIAL_VERSION:
                switch (subsetCategory) {
                    case SubsetKey.CATEGORY_CORPUS:
                        return "extraitcorpus";
                    case SubsetKey.CATEGORY_ALBUM:
                        return "extraitalbum";
                    case SubsetKey.CATEGORY_ADDENDA:
                        return "extraitaddenda";
                    case SubsetKey.CATEGORY_THESAURUS:
                        return "extraitthesaurus";
                    default:
                        throw new SwitchException("Unknown type: " + subsetCategory);
                }
            default:
                switch (subsetCategory) {
                    case SubsetKey.CATEGORY_CORPUS:
                        return "fiches";
                    case SubsetKey.CATEGORY_ALBUM:
                        return "illustrations";
                    case SubsetKey.CATEGORY_ADDENDA:
                        return "documents";
                    case SubsetKey.CATEGORY_THESAURUS:
                        return "motcles";
                    default:
                        throw new SwitchException("Unknown category: " + subsetCategory);
                }
        }
    }

    public String getSubsetTitleTagName() {
        switch (extractVersion) {
            case ExtractionConstants.INITIAL_VERSION:
                return "intitule";
            default:
                return "title";
        }
    }

    public String getWeightAttributeName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "poids";
        } else {
            return "weight";
        }
    }

    public String getPersonTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "personne";
        } else {
            return "person";
        }
    }

    public String getNumberTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "nombre";
        } else {
            return "number";
        }
    }

    public String getAmountTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "montant";
        } else {
            return "amount";
        }
    }

    public String getLanguageTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "langue";
        } else {
            return "language";
        }
    }

    public String getEmailTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "courriel";
        } else {
            return "email";
        }
    }

    public String getCountryTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "pays";
        } else {
            return "country";
        }
    }

    public String getDateTagName() {
        if (extractVersion < ExtractionConstants.INTERNATIONAL_VERSION) {
            return "datation";
        } else {
            return "date";
        }
    }

}
