/* FichothequeLib_Tools - Copyright (c) 2015-2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.permission;

import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.permission.PermissionSummary;


/**
 *
 * @author Vincent Calame
 */
public class PermissionPredicate implements Predicate<SubsetItem> {

    private final PermissionSummary permissionSummary;
    private final boolean read;


    private PermissionPredicate(PermissionSummary permissionSummary, boolean read) {
        this.permissionSummary = permissionSummary;
        this.read = read;
    }


    @Override
    public boolean test(SubsetItem subsetItem) {
        if (read) {
            return permissionSummary.canRead(subsetItem);
        } else {
            return permissionSummary.canWrite(subsetItem);
        }
    }

    public static PermissionPredicate read(PermissionSummary permissionSummary) {
        return new PermissionPredicate(permissionSummary, true);
    }

    public static PermissionPredicate write(PermissionSummary permissionSummary) {
        return new PermissionPredicate(permissionSummary, false);
    }

}
