/* FichothequeLib_Tools - Copyright (c) 2024-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.corpus;

import net.fichotheque.corpus.FicheChange;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.TiesImportBuilder;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.fichotheque.importation.TiesImport;


/**
 *
 * @author Vincent Calame
 */
public class EditFicheImportBuilder {

    private final int ficheId;
    protected FicheChangeBuilder ficheChangeBuilder;
    protected AttributeChangeBuilder attributeChangeBuilder;
    protected TiesImportBuilder tiesImportBuilder;
    protected FuzzyDate creationDate;

    public EditFicheImportBuilder(int ficheId) {
        this.ficheId = ficheId;
    }

    public EditFicheImportBuilder setCreationDate(FuzzyDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public FicheChangeBuilder getFicheChangeBuilder() {
        if (ficheChangeBuilder == null) {
            ficheChangeBuilder = new FicheChangeBuilder();
        }
        return ficheChangeBuilder;
    }

    public AttributeChangeBuilder getAttributeChangeBuilder() {
        if (attributeChangeBuilder == null) {
            attributeChangeBuilder = new AttributeChangeBuilder();
        }
        return attributeChangeBuilder;
    }

    public TiesImportBuilder getTiesImportBuilder() {
        if (tiesImportBuilder == null) {
            tiesImportBuilder = new TiesImportBuilder();
        }
        return tiesImportBuilder;
    }

    protected FicheChange getFicheChange() {
        if (ficheChangeBuilder == null) {
            return CorpusUtils.EMPTY_FICHECHANGE;
        } else {
            return ficheChangeBuilder.toFicheChange();
        }
    }

    protected AttributeChange getAttributeChange() {
        if (attributeChangeBuilder == null) {
            return AttributeUtils.EMPTY_ATTRIBUTECHANGE;
        } else {
            return attributeChangeBuilder.toAttributeChange();
        }
    }

    protected TiesImport getTiesImport() {
        if (tiesImportBuilder == null) {
            return ImportationUtils.EMPTY_TIESIMPORT;
        } else {
            return tiesImportBuilder.toTiesImport();
        }
    }

    public CorpusImport.EditFicheImport toEditFicheImport() {
        return new InternalEditFicheImport(ficheId, getFicheChange(), getAttributeChange(), getTiesImport(), creationDate);
    }

    public static EditFicheImportBuilder init(int ficheId) {
        return new EditFicheImportBuilder(ficheId);
    }


    private static class InternalEditFicheImport implements CorpusImport.EditFicheImport {

        private final int ficheId;
        private final FicheChange ficheChange;
        private final AttributeChange attributeChange;
        private final TiesImport tiesImport;
        private final FuzzyDate creationDate;

        private InternalEditFicheImport(int ficheId, FicheChange ficheChange, AttributeChange attributeChange, TiesImport tiesImport, FuzzyDate creationDate) {
            this.ficheId = ficheId;
            this.ficheChange = ficheChange;
            this.attributeChange = attributeChange;
            this.tiesImport = tiesImport;
            this.creationDate = creationDate;
        }

        @Override
        public int getFicheId() {
            return ficheId;
        }

        @Override
        public FicheChange getFicheChange() {
            return ficheChange;
        }

        @Override
        public AttributeChange getAttributeChange() {
            return attributeChange;
        }

        @Override
        public TiesImport getTiesImport() {
            return tiesImport;
        }

        @Override
        public FuzzyDate getCreationDate() {
            return creationDate;
        }

    }

}
