/* FichothequeLib_Tools - Copyright (c) 2015-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.parsers;

import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.AttributeFormatter;
import net.fichotheque.tools.format.DefaultPatternCatalog;
import net.fichotheque.tools.format.catalogs.AttributeFormatterCatalog;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.format.FormatConstants;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;


/**
 *
 * @author Vincent Calame
 */
public final class AttributeFormatterParser {

    private AttributeFormatterParser() {

    }

    public static AttributeFormatter parse(String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPatternCatalog.ATTRIBUTE;
        }
        try {
            return parse(pattern, formatContext);
        } catch (ErrorMessageException fe) {
            messageHandler.addMessage(FormatConstants.SEVERE_PATTERN, fe.getErrorMessage());
            return null;
        }
    }

    public static AttributeFormatter parse(String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext), pattern);
        return new InternalAttributeFormatter(partArray);
    }


    private static class InternalAttributeFormatter implements AttributeFormatter {

        private final Object[] partArray;

        private InternalAttributeFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatAttributeValue(String attributeValue, int valueIndex, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            int length = partArray.length;
            for (int i = 0; i < length; i++) {
                Object obj = partArray[i];
                if (obj instanceof String) {
                    buf.append((String) obj);
                    continue;
                }
                AttributeFormatter formatter = (AttributeFormatter) obj;
                buf.append(formatter.formatAttributeValue(attributeValue, valueIndex, formatSource));
            }
            return buf.toString();
        }

    }


    private static class InternalInstructionResolver implements InstructionResolver {

        private final InstructionResolverProvider provider;

        private InternalInstructionResolver(FormatContext formatContext) {
            this.provider = formatContext.getInstructionResolverProvider();
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            InstructionResolver resolver = provider.getInstructionResolver(net.fichotheque.format.formatters.ValueFormatter.class);
            if (resolver != null) {
                Object formatter = resolver.resolve(instruction);
                if (formatter != null) {
                    return formatter;
                }
            }
            Argument arg1 = instruction.get(0);
            String key = arg1.getKey();
            switch (key) {
                case "formsyntax":
                    return AttributeFormatterCatalog.FORMSYNTAX;
                case "value":
                    return AttributeFormatterCatalog.VALUE;
                default:
                    return null;
            }
        }

    }


}
