/* FichothequeLib_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.junction;

import net.fichotheque.SubsetItem;
import net.fichotheque.utils.JunctionUtils;


/**
 *
 * @author Vincent Calame
 */
public interface Liaison {

    public SubsetItem getSubsetItem();

    public Junction getJunction();

    public Tie getTie();

    public default int getPosition() {
        SubsetItem subsetItem = getSubsetItem();
        JunctionKey junctionKey = getJunction().getJunctionKey();
        return JunctionUtils.getPosition(subsetItem, junctionKey, getTie());
    }

    public default int getPositionNumber() {
        SubsetItem subsetItem = getSubsetItem();
        JunctionKey junctionKey = getJunction().getJunctionKey();
        int id = subsetItem.getId();
        if ((junctionKey.getId1() == id) && (junctionKey.getSubsetKey1().equals(subsetItem.getSubsetKey()))) {
            return 1;
        } else {
            return 2;
        }
    }

}
