/* BdfServer_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.importation;

import java.util.List;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.SourceLog;


/**
 *
 * @author Vincent Calame
 */
public interface ParseResult {

    public final static String SEVERE_COLUMN = "severe.column";
    public final static String WARNING_COLUMN = "warning.column";
    public final static String SEVERE_PARSE = "severe.parse";
    public final static String SEVERE_FICHOTHEQUE = "severe.fichotheque";

    public String getType();

    public SourceLog getColumnLog();

    public LineLogs getLineLogs();

    public List<ResultItem> getResultItemList();

    public String getPath();

    public default boolean isAllCorrect() {
        if (!getColumnLog().isEmpty()) {
            return false;
        }
        if (!getLineLogs().isEmpty()) {
            return false;
        }
        return true;
    }


    public static interface ResultItem {

        public Object getKeyObject();

        public Object getValueObject();

        public int getLineNumber();

    }

}
