/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import net.mapeadores.util.logging.CommandMessage;


/**
 *
 * @author Vincent Calame
 */
public class SubscribeResult {

    private final SubscribeParameters subscribeParameters;
    private CommandMessage commandMessage;
    private String fichothequeName;
    private String login = "";

    public SubscribeResult(SubscribeParameters subscribeParameters) {
        this.subscribeParameters = subscribeParameters;
    }

    public SubscribeParameters subscribeParameters() {
        return subscribeParameters;
    }

    public CommandMessage commandMessage() {
        return commandMessage;
    }

    public SubscribeResult commandMessage(CommandMessage commandMessage) {
        this.commandMessage = commandMessage;
        return this;
    }

    public String fichothequeName() {
        return fichothequeName;
    }

    public SubscribeResult fichothequeName(String fichothequeName) {
        this.fichothequeName = fichothequeName;
        return this;
    }

    public String login() {
        return login;
    }

    public SubscribeResult login(String login) {
        this.login = login;
        return this;
    }

    public static SubscribeResult init(SubscribeParameters subscribeParameters) {
        return new SubscribeResult(subscribeParameters);
    }

}
