/* BdfServer_Multi - Copyright (c) 2023-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.impl;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.File;
import net.fichotheque.sphere.LoginKey;


/**
 *
 * @author Vincent Calame
 */
public final class MultiStorageFileCatalog {

    private MultiStorageFileCatalog() {

    }

    public static StorageFile multiMetadata(StorageDirectory storageDirectory) {
        String path = "metadata.xml";
        return storageDirectory.getStorageFile(path);
    }

    public static StorageFile centralSphereMetadata(StorageDirectory storageDirectory, String name) {
        String path = "spheres" + File.separator + name + File.separator + "metadata.xml";
        return storageDirectory.getStorageFile(path);
    }

    public static StorageFile centralUser(StorageDirectory storageDirectory, LoginKey loginKey) {
        String path = "spheres/" + loginKey.getSphereName() + "/users/" + loginKey.getLogin() + ".xml";
        return storageDirectory.getStorageFile(path);
    }

}
