/* BdfServer_HtmlProducers - Copyright (c) 2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadResult;
import fr.exemole.bdfserver.tools.filesupload.TmpFileGroup;
import fr.exemole.bdfserver.tools.filesupload.TmpFileInfo;
import fr.exemole.bdfserver.tools.filesupload.UploadError;
import java.util.List;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.localisation.Message;


/**
 *
 * @author Vincent Calame
 */
public class FilesUploadResultHtmlProducer extends BdfServerHtmlProducer {

    private final FilesUploadResult filesUploadResult;
    private final String callKey;

    public FilesUploadResultHtmlProducer(BdfParameters bdfParameters, FilesUploadResult filesUploadResult, String callKey) {
        super(bdfParameters);
        this.filesUploadResult = filesUploadResult;
        this.callKey = callKey;
        setBodyCssClass("global-body-Transparent");
        addJsLib(FicheJsLibs.FILESUPLOAD);
    }

    @Override
    public void printHtml() {
        String clientId = generateId();
        JsObject args = JsObject.init()
                .put("step", "result")
                .put("clientId", clientId)
                .put("callKey", callKey)
                .put("result", convertResult());
        start();
        this
                .SCRIPT()
                .__jsObject("FilesUpload.ARGS", args)
                ._SCRIPT();
        this
                .DIV(HA.id(clientId))
                ._DIV();
        end();
    }

    private JsObject convertResult() {
        if (filesUploadResult instanceof FilesUploadResult.Unique) {
            return convertUniqueResult((FilesUploadResult.Unique) filesUploadResult);
        }
        if (filesUploadResult instanceof FilesUploadResult.Multi) {
            return convertMultiResult((FilesUploadResult.Multi) filesUploadResult);
        }
        return null;
    }

    private JsObject convertUniqueResult(FilesUploadResult.Unique uniqueResult) {
        JsObject result = JsObject.init()
                .put("type", "unique")
                .put("tmpFileArray", convertTmpFileInfoList(uniqueResult.getTmpFileInfoList()))
                .put("uploadErrorArray", convertUploadErrorList(uniqueResult.getUploadErrorList()));
        return result;
    }

    private JsObject convertMultiResult(FilesUploadResult.Multi multiResult) {
        JsObject result = JsObject.init()
                .put("type", "multi")
                .put("groupArray", convertTmpFileGroupList(multiResult.getTmpFileGroupList()))
                .put("uploadErrorArray", convertUploadErrorList(multiResult.getUploadErrorList()));
        return result;
    }

    private JsObject[] convertTmpFileGroupList(List<TmpFileGroup> tmpFileGroupList) {
        int size = tmpFileGroupList.size();
        JsObject[] array = new JsObject[size];
        for (int i = 0; i < size; i++) {
            TmpFileGroup tmpFileGroup = tmpFileGroupList.get(i);
            array[i] = JsObject.init()
                    .put("originalBasename", tmpFileGroup.getOriginalBasename())
                    .put("normalizedBasename", tmpFileGroup.getNormalizedBasename())
                    .put("tmpFileArray", convertTmpFileInfoList(tmpFileGroup.getTmpFileInfoList()));
        }
        return array;
    }

    private JsObject[] convertTmpFileInfoList(List<TmpFileInfo> tmpFileInfoList) {
        int size = tmpFileInfoList.size();
        JsObject[] array = new JsObject[size];
        for (int i = 0; i < size; i++) {
            array[i] = convertTmpFileInfo(tmpFileInfoList.get(i));
        }
        return array;
    }

    private JsObject convertTmpFileInfo(TmpFileInfo tmpFileInfo) {
        return JsObject.init()
                .put("extension", tmpFileInfo.getExtension())
                .put("tmpFileName", tmpFileInfo.getTmpFileName())
                .put("originalBasename", tmpFileInfo.getOriginalBasename())
                .put("normalizedBasename", tmpFileInfo.getNormalizedBasename());
    }

    private JsObject[] convertUploadErrorList(List<UploadError> uploadErrorList) {
        int size = uploadErrorList.size();
        JsObject[] array = new JsObject[size];
        for (int i = 0; i < size; i++) {
            array[i] = convertUploadError(uploadErrorList.get(i));
        }
        return array;
    }

    private JsObject convertUploadError(UploadError uploadError) {
        return JsObject.init()
                .put("tmpFile", convertTmpFileInfo(uploadError.getTmpFileInfo()))
                .put("message", convertMessage(uploadError.getMessage()));
    }

    private JsObject convertMessage(Message message) {
        return JsObject.init()
                .put("key", message.getMessageKey())
                .put("text", getLocalization(message))
                .put("values", message.getMessageValues());
    }

}
