/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Consumer;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.io.CharSequenceOdSource;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.opendocument.io.Pictures;
import net.mapeadores.opendocument.io.StylesXMLPart;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.opendocument.io.odtable.TableSettings;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public final class OdUtils {
    public static final short OD_TEXT = 1;
    public static final short OD_SPREADSHEET = 2;
    public static final short OD_DATABASE = 3;
    public static final short OD_CHART = 4;
    public static final short OD_FORMULA = 5;
    public static final short OD_DRAWING = 6;
    public static final short OD_IMAGE = 7;
    public static final short OD_MASTER = 8;
    public static final short OD_PRESENTATION = 9;
    public static final OdSource EMPTY_ODSOURCE = new EmptyOdSource();

    private OdUtils() {
    }

    public static String getMimeType(short odType) {
        switch (odType) {
            case 1: {
                return "application/vnd.oasis.opendocument.text";
            }
            case 2: {
                return "application/vnd.oasis.opendocument.spreadsheet";
            }
            case 3: {
                return "application/vnd.oasis.opendocument.database";
            }
            case 4: {
                return "application/vnd.oasis.opendocument.chart";
            }
            case 5: {
                return "application/vnd.oasis.opendocument.formula";
            }
            case 6: {
                return "application/vnd.oasis.opendocument.graphics";
            }
            case 7: {
                return "application/vnd.oasis.opendocument.image";
            }
            case 8: {
                return "application/vnd.oasis.opendocument.text-master";
            }
            case 9: {
                return "application/vnd.oasis.opendocument.presentation";
            }
        }
        throw new IllegalArgumentException("unknown odType = " + odType);
    }

    public static String getExtension(short odType) {
        switch (odType) {
            case 1: {
                return "odt";
            }
            case 2: {
                return "ods";
            }
            case 3: {
                return "odb";
            }
            case 4: {
                return "odc";
            }
            case 5: {
                return "odf";
            }
            case 6: {
                return "odg";
            }
            case 7: {
                return "odi";
            }
            case 8: {
                return "odm";
            }
            case 9: {
                return "odp";
            }
        }
        throw new IllegalArgumentException("unknown odType = " + odType);
    }

    public static boolean isOdExtension(String extension) {
        try {
            OdUtils.getOdType(extension);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static short getOdType(String extension) {
        if (extension.equals("odt")) {
            return 1;
        }
        if (extension.equals("ods")) {
            return 2;
        }
        if (extension.equals("odb")) {
            return 3;
        }
        if (extension.equals("odc")) {
            return 4;
        }
        if (extension.equals("odf")) {
            return 5;
        }
        if (extension.equals("odg")) {
            return 6;
        }
        if (extension.equals("odi")) {
            return 7;
        }
        if (extension.equals("odm")) {
            return 8;
        }
        if (extension.equals("odp")) {
            return 9;
        }
        throw new IllegalArgumentException("wrong extension = " + extension);
    }

    public static List<Pictures.Entry> wrap(Pictures.Entry[] array) {
        return new PictureList(array);
    }

    public static void writeSpreadSheetDocumentContent(OutputStream outputStream, Consumer<Writer> spreadSheetProducer, StyleManager styleManager) throws IOException {
        BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
        xmlWriter.appendXMLDeclaration();
        OdXML.openDocumentContent(xmlWriter);
        OdXML.openAutomaticStyles(xmlWriter);
        styleManager.insertAutomaticStyles(xmlWriter);
        OdXML.closeAutomaticStyles(xmlWriter);
        OdXML.openBody(xmlWriter);
        OdXML.openSpreadsheet(xmlWriter);
        try {
            spreadSheetProducer.accept(buf);
        }
        catch (NestedIOException ioe) {
            throw ioe.getIOException();
        }
        OdXML.closeSpreadsheet(xmlWriter);
        OdXML.closeBody(xmlWriter);
        OdXML.closeDocumentContent(xmlWriter);
        buf.flush();
    }

    public static OdSource getSettingsOdSource(Collection<TableSettings> settings) {
        return new SettingsOdSource(settings);
    }

    public static void writeSettings(OutputStream outputStream, Collection<TableSettings> settings) throws IOException {
        BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
        xmlWriter.appendXMLDeclaration();
        OdXML.openDocumentSettings(xmlWriter);
        OdXML.openSettings(xmlWriter);
        OdXML.openConfigItemSet(xmlWriter, "ooo:view-settings");
        OdXML.openConfigItemMapIndexed(xmlWriter, "Views");
        OdXML.openConfigItemMapEntry(xmlWriter, null);
        OdXML.addConfigItem(xmlWriter, "ViewId", "string", "view1");
        OdXML.openConfigItemMapNamed(xmlWriter, "Tables");
        for (TableSettings tableSettings : settings) {
            OdUtils.writeTableSettings(xmlWriter, tableSettings);
        }
        OdXML.closeConfigItemMapNamed(xmlWriter);
        OdXML.closeConfigItemMapEntry(xmlWriter);
        OdXML.closeConfigItemMapIndexed(xmlWriter);
        OdXML.closeConfigItemSet(xmlWriter);
        OdXML.closeSettings(xmlWriter);
        OdXML.closeDocumentSettings(xmlWriter);
        buf.flush();
    }

    public static OdSource toStyleOdSource(ElementMaps elementMaps, boolean isSpreadSheet) {
        return new CharSequenceOdSource(OdUtils.toStyleXml(elementMaps, isSpreadSheet), "UTF-8");
    }

    public static String toStyleXml(ElementMaps elementMaps, boolean isSpreadSheet) {
        StringBuilder buf = new StringBuilder();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
        try {
            xmlWriter.appendXMLDeclaration();
            StylesXMLPart stylesPart = new StylesXMLPart(xmlWriter);
            stylesPart.openStyleDocument();
            stylesPart.openStyles();
            if (elementMaps != null) {
                stylesPart.insertStyles(elementMaps, isSpreadSheet);
            }
            stylesPart.closeStyles();
            stylesPart.closeStyleDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    private static void writeTableSettings(XMLWriter xmlWriter, TableSettings tableSettings) throws IOException {
        OdXML.openConfigItemMapEntry(xmlWriter, tableSettings.tableName());
        int fixedColumns = tableSettings.fixedColumns();
        int fixedRows = tableSettings.fixedRows();
        if (fixedColumns > 0) {
            OdXML.addConfigItem(xmlWriter, "HorizontalSplitMode", "short", "2");
            OdXML.addConfigItem(xmlWriter, "HorizontalSplitPosition", "int", String.valueOf(fixedColumns));
            OdXML.addConfigItem(xmlWriter, "PositionLeft", "int", "0");
            OdXML.addConfigItem(xmlWriter, "PositionRight", "int", String.valueOf(fixedColumns));
        }
        if (fixedRows > 0) {
            OdXML.addConfigItem(xmlWriter, "VerticalSplitMode", "short", "2");
            OdXML.addConfigItem(xmlWriter, "VerticalSplitPosition", "int", String.valueOf(fixedRows));
            OdXML.addConfigItem(xmlWriter, "PositionTop", "int", "0");
            OdXML.addConfigItem(xmlWriter, "PositionBottom", "int", String.valueOf(fixedRows));
        }
        OdXML.closeConfigItemMapEntry(xmlWriter);
    }

    private static class PictureList
    extends AbstractList<Pictures.Entry>
    implements RandomAccess {
        private final Pictures.Entry[] array;

        private PictureList(Pictures.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Pictures.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class SettingsOdSource
    implements OdSource {
        private final Collection<TableSettings> settings;

        private SettingsOdSource(Collection<TableSettings> settings) {
            this.settings = settings;
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            OdUtils.writeSettings(outputStream, this.settings);
        }
    }

    private static class EmptyOdSource
    implements OdSource {
        private EmptyOdSource() {
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
        }
    }
}

