/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.io.IOException;

public final class SyntaxUtils {
    private SyntaxUtils() {
    }

    public static void appendErrorSpan(Appendable buf, String value) throws IOException {
        SyntaxUtils.appendSpan(buf, "cm-error", value);
    }

    public static void appendSpan(Appendable buf, String classes, String value) throws IOException {
        if (value.length() == 0) {
            return;
        }
        buf.append("<span class=\"");
        buf.append(classes);
        buf.append("\">");
        SyntaxUtils.escape(buf, value);
        buf.append("</span>");
    }

    public static void escape(Appendable buf, String value) throws IOException {
        int length = value.length();
        block6: for (int i = 0; i < length; ++i) {
            char carac = value.charAt(i);
            switch (carac) {
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
    }
}

