/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.Normalizer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;

public final class AddendaUtils {
    public static final List<Document> EMPTY_DOCUMENTLIST = Collections.emptyList();

    private AddendaUtils() {
    }

    public static String toTitle(Document document) {
        List<Version> versionList = document.getVersionList();
        switch (versionList.size()) {
            case 0: {
                return document.getBasename();
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(document.getBasename());
        buf.append(" [ ");
        boolean next = false;
        for (Version version : versionList) {
            if (next) {
                buf.append(" / ");
            } else {
                next = true;
            }
            buf.append(".");
            buf.append(version.getExtension());
        }
        buf.append(" ]");
        return buf.toString();
    }

    public static String toVersionKey(Version version) {
        Document document = version.getDocument();
        return document.getGlobalId() + "." + version.getExtension();
    }

    public static String checkBasename(String basename, Addenda addenda) {
        String result;
        if ((basename = AddendaUtils.checkNormalization(basename)) == null) {
            basename = "document";
        }
        if (addenda.getDocumentByBasename(basename) == null) {
            return basename;
        }
        NameIncrement nameIncrement = new NameIncrement(basename, 2);
        while (addenda.getDocumentByBasename(result = nameIncrement.toString()) != null) {
            nameIncrement.incremente();
        }
        return result;
    }

    public static String checkNormalization(String s) {
        s = s.toLowerCase();
        s = Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        StringBuilder buf = new StringBuilder();
        int length = s.length();
        boolean previousBlank = false;
        int nonLatinCount = 0;
        for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            if (AddendaUtils.testChar(carac)) {
                buf.append(carac);
                previousBlank = false;
                continue;
            }
            if (Character.isLetter(carac)) {
                ++nonLatinCount;
                continue;
            }
            if (previousBlank) continue;
            buf.append('_');
            previousBlank = true;
        }
        if (nonLatinCount > length / 2) {
            return null;
        }
        return buf.toString();
    }

    public static boolean testExtension(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char carac = s.charAt(i);
            if (carac >= '0' && carac <= '9' || carac >= 'a' && carac <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean testBasename(String basename) {
        if (basename == null) {
            return false;
        }
        if (basename.length() == 0) {
            return false;
        }
        int length = basename.length();
        for (int i = 0; i < length; ++i) {
            char carac = basename.charAt(i);
            if (AddendaUtils.testChar(carac)) continue;
            return false;
        }
        return true;
    }

    private static boolean testChar(char carac) {
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        switch (carac) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static List<Document> wrap(Document[] array) {
        return new DocumentList(array);
    }

    public static List<Version> wrap(Version[] array) {
        return new VersionList(array);
    }

    private static class NameIncrement {
        private final String basename;
        private int val;

        private NameIncrement(String basename, int val) {
            this.basename = basename;
            this.val = val;
        }

        private void incremente() {
            ++this.val;
        }

        public String toString() {
            return this.basename + "-" + this.val;
        }
    }

    private static class DocumentList
    extends AbstractList<Document>
    implements RandomAccess {
        private final Document[] array;

        private DocumentList(Document[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Document get(int index) {
            return this.array[index];
        }
    }

    private static class VersionList
    extends AbstractList<Version>
    implements RandomAccess {
        private final Version[] array;

        private VersionList(Version[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Version get(int index) {
            return this.array[index];
        }
    }
}

