/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.junction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Tie;
import net.fichotheque.tools.junction.JunctionChangeBuilder;
import net.fichotheque.tools.junction.JunctionChangesBuilder;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.utils.JunctionUtils;

public class JunctionChangeEngine {
    private static final short CLEAR_EXISTING = 1;
    private static final short APPEND_AND_WEIGHT_REPLACE = 2;
    private static final short APPEND_AND_WEIGHT_MAX = 3;
    private static final short APPEND_AND_WEIGHT_NOCHANGE = 4;
    private final short changeType;
    private final SubsetItem mainSubsetItem;
    private final Map<String, NewJunction> junctionMap = new LinkedHashMap<String, NewJunction>();
    private final Map<SubsetKey, SubsetInfo> subsetMap = new HashMap<SubsetKey, SubsetInfo>();
    private final boolean withIncludeKeyFilter;

    private JunctionChangeEngine(short changeType, SubsetItem mainSubsetItem) {
        this.changeType = changeType;
        this.mainSubsetItem = mainSubsetItem;
        this.withIncludeKeyFilter = false;
    }

    private JunctionChangeEngine(short changeType, SubsetItem mainSubsetItem, Collection<IncludeKey> scope) {
        this.changeType = changeType;
        this.mainSubsetItem = mainSubsetItem;
        this.withIncludeKeyFilter = true;
        Fichotheque fichotheque = mainSubsetItem.getFichotheque();
        for (IncludeKey includeKey : scope) {
            Subset subset = fichotheque.getSubset(includeKey.getSubsetKey());
            if (subset == null) continue;
            this.initSubset(subset, includeKey.getMode(), includeKey.getWeightFilter());
        }
    }

    private JunctionChangeEngine() {
        this.changeType = 1;
        this.mainSubsetItem = null;
        this.withIncludeKeyFilter = false;
    }

    private void initSubset(Subset subset, String mode, int weightFilter) {
        SubsetInfo subsetInfo = this.subsetMap.get(subset.getSubsetKey());
        if (subsetInfo == null) {
            subsetInfo = new SubsetInfo(subset);
            this.subsetMap.put(subset.getSubsetKey(), subsetInfo);
        }
        subsetInfo.add(mode, weightFilter);
    }

    public void addJunctions(Junctions junctions, Predicate<SubsetItem> predicate) {
        for (Junctions.Entry entry : junctions.getEntryList()) {
            SubsetItem otherSubsetItem = entry.getSubsetItem();
            if (!predicate.test(otherSubsetItem)) continue;
            for (Tie tie : entry.getJunction().getTieList()) {
                try {
                    this.addTie(otherSubsetItem, tie.getMode(), tie.getWeight());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void addTie(TieBuffer tieBuffer) {
        this.addTie(tieBuffer.getSubsetItem(), tieBuffer.getMode(), tieBuffer.getWeight());
    }

    public void addTie(SubsetItem otherSubsetItem, String mode, int weight) {
        if (this.isMainSubsetItem(otherSubsetItem)) {
            return;
        }
        SubsetInfo subsetInfo = this.getOrCreateSubsetInfo(otherSubsetItem);
        ModeInfo modeInfo = this.getOrCreateModeInfo(subsetInfo, mode);
        if (!modeInfo.containsWeight(weight)) {
            throw new IllegalArgumentException("Weight not declared : " + weight);
        }
        boolean mainInFirst = this.mainSubsetItem != null ? JunctionKey.getOrder(this.mainSubsetItem, otherSubsetItem) == 1 : true;
        NewTie newTie = new NewTie(otherSubsetItem, mode, weight, mainInFirst);
        boolean done = this.getOrCreateNewJunction(otherSubsetItem).adNewTie(newTie);
        if (done) {
            subsetInfo.addNewTie(newTie);
        }
    }

    public void removeTie(SubsetItem otherSubsetItem, String mode) {
        if (this.isMainSubsetItem(otherSubsetItem)) {
            return;
        }
        SubsetInfo subsetInfo = this.getOrCreateSubsetInfo(otherSubsetItem);
        this.getOrCreateModeInfo(subsetInfo, mode);
        this.getOrCreateNewJunction(otherSubsetItem).addRemovedMode(mode);
    }

    public JunctionChanges toJunctionChanges() {
        if (this.mainSubsetItem == null) {
            this.checkNew();
        } else {
            this.checkExisting();
        }
        JunctionChangesBuilder builder = new JunctionChangesBuilder();
        for (NewJunction newJunction : this.junctionMap.values()) {
            if (newJunction.isRemoved()) {
                builder.addRemoved(newJunction.otherSubsetItem);
                continue;
            }
            if (newJunction.isCancelled()) continue;
            JunctionChange junctionChange = newJunction.toJunctionChange();
            builder.addEntry(newJunction.otherSubsetItem, junctionChange);
        }
        return builder.toJunctionChanges();
    }

    public static JunctionChangeEngine newEngine() {
        return new JunctionChangeEngine();
    }

    public static JunctionChangeEngine clearExistingEngine(SubsetItem mainSubsetItem) {
        return new JunctionChangeEngine(1, mainSubsetItem);
    }

    public static JunctionChangeEngine clearExistingEngine(SubsetItem mainSubsetItem, Collection<IncludeKey> scope) {
        return new JunctionChangeEngine(1, mainSubsetItem, scope);
    }

    public static JunctionChangeEngine appendEngine(SubsetItem mainSubsetItem) {
        return new JunctionChangeEngine(4, mainSubsetItem);
    }

    public static JunctionChangeEngine appendOrWeightReplaceEngine(SubsetItem mainSubsetItem) {
        return new JunctionChangeEngine(2, mainSubsetItem);
    }

    public static JunctionChangeEngine appendOrWeightMaxEngine(SubsetItem mainSubsetItem) {
        return new JunctionChangeEngine(3, mainSubsetItem);
    }

    private boolean isMainSubsetItem(SubsetItem otherSubsetItem) {
        return this.mainSubsetItem != null && this.mainSubsetItem.equals(otherSubsetItem);
    }

    private SubsetInfo getOrCreateSubsetInfo(SubsetItem otherSubsetItem) {
        SubsetInfo subsetInfo = this.subsetMap.get(otherSubsetItem.getSubsetKey());
        if (subsetInfo == null) {
            if (this.withIncludeKeyFilter) {
                throw new IllegalArgumentException("Subset not declared : " + otherSubsetItem.getSubsetKey());
            }
            subsetInfo = new SubsetInfo(otherSubsetItem.getSubset());
            this.subsetMap.put(otherSubsetItem.getSubsetKey(), subsetInfo);
        }
        return subsetInfo;
    }

    private ModeInfo getOrCreateModeInfo(SubsetInfo subsetInfo, String mode) {
        ModeInfo modeInfo = subsetInfo.getModeInfo(mode);
        if (modeInfo == null) {
            if (this.withIncludeKeyFilter) {
                throw new IllegalArgumentException("Mode not declared : " + mode);
            }
            modeInfo = subsetInfo.add(mode, -1);
        }
        return modeInfo;
    }

    private NewJunction getOrCreateNewJunction(SubsetItem otherSubsetItem) {
        String stringKey = JunctionChangeEngine.toStringKey(otherSubsetItem);
        NewJunction newJunction = this.junctionMap.get(stringKey);
        if (newJunction == null) {
            newJunction = new NewJunction(otherSubsetItem);
            this.junctionMap.put(stringKey, newJunction);
        }
        return newJunction;
    }

    private void checkNew() {
        for (Map.Entry<SubsetKey, SubsetInfo> entry : this.subsetMap.entrySet()) {
            SubsetInfo subsetInfo = entry.getValue();
            PositionMaxima positionMaxima = new PositionMaxima();
            for (NewTie newTie : subsetInfo.newTieList) {
                if (newTie.isCanceled() || !newTie.isMainPositionUndefined()) continue;
                newTie.setMainPosition(positionMaxima.getNewPosition(newTie.getMode()));
            }
        }
    }

    private void checkExisting() {
        Fichotheque fichotheque = this.mainSubsetItem.getFichotheque();
        for (Map.Entry<SubsetKey, SubsetInfo> entry : this.subsetMap.entrySet()) {
            SubsetInfo subsetInfo = entry.getValue();
            Junctions currentJunctions = fichotheque.getJunctions(this.mainSubsetItem, subsetInfo.subset);
            PositionMaxima positionMaxima = new PositionMaxima();
            if (this.changeType != 1) {
                for (Junctions.Entry currentEntry : currentJunctions.getEntryList()) {
                    Junction junction;
                    positionMaxima.checkJunction(junction, (junction = currentEntry.getJunction()).getJunctionKey().getOrder(this.mainSubsetItem) != 1);
                }
            }
            for (Junctions.Entry currentEntry : currentJunctions.getEntryList()) {
                SubsetItem otherSubsetItem = currentEntry.getSubsetItem();
                Junction currentJunction = currentEntry.getJunction();
                String key = JunctionChangeEngine.toStringKey(otherSubsetItem);
                NewJunction newJunction = this.junctionMap.get(key);
                if (newJunction == null) {
                    if (this.changeType != 1) continue;
                    newJunction = this.initRemovedNewJunction(subsetInfo, otherSubsetItem, currentJunction);
                    this.junctionMap.put(key, newJunction);
                    continue;
                }
                for (Tie currentTie : currentJunction.getTieList()) {
                    if (!subsetInfo.containsMode(currentTie.getMode())) continue;
                    newJunction.checkCurrentTie(currentTie, this.changeType);
                }
            }
            for (NewTie newTie : subsetInfo.newTieList) {
                if (newTie.isCanceled()) continue;
                if (newTie.isMainPositionUndefined()) {
                    PositionMaxima otherPositionMaxima = subsetInfo.getMainPositionMaxima(newTie.getOtherSubsetItem(), this.mainSubsetItem.getSubset());
                    newTie.setMainPosition(otherPositionMaxima.getNewPosition(newTie.getMode()));
                }
                if (!newTie.isOtherPositionUndefined()) continue;
                newTie.setOtherPosition(positionMaxima.getNewPosition(newTie.getMode()));
            }
        }
    }

    private NewJunction initRemovedNewJunction(SubsetInfo subsetInfo, SubsetItem otherSubsetItem, Junction junction) {
        List<Tie> tieList = junction.getTieList();
        int tieCount = tieList.size();
        int removeCount = 0;
        NewJunction newJunction = new NewJunction(otherSubsetItem);
        for (Tie tie : tieList) {
            int weight;
            String mode = tie.getMode();
            ModeInfo modeInfo = subsetInfo.getModeInfo(mode);
            if (modeInfo == null || !modeInfo.containsWeight(weight = tie.getWeight())) continue;
            newJunction.addRemovedMode(mode);
            ++removeCount;
        }
        if (removeCount == tieCount) {
            newJunction.setRemoveAll(true);
        }
        return newJunction;
    }

    private static String toStringKey(SubsetItem subsetItem) {
        return subsetItem.getSubsetKey() + "/" + subsetItem.getId();
    }

    private static class SubsetInfo {
        private final Fichotheque fichotheque;
        private final Subset subset;
        private final Map<String, ModeInfo> modeInfoMap = new HashMap<String, ModeInfo>();
        private List<NewTie> newTieList = new ArrayList<NewTie>();
        private final Map<Integer, PositionMaxima> maximaMap = new HashMap<Integer, PositionMaxima>();

        private SubsetInfo(Subset subset) {
            this.subset = subset;
            this.fichotheque = subset.getFichotheque();
        }

        private ModeInfo add(String mode, int weightFilter) {
            ModeInfo modeInfo = this.modeInfoMap.get(mode);
            if (modeInfo == null) {
                modeInfo = new ModeInfo(mode);
                this.modeInfoMap.put(mode, modeInfo);
            }
            modeInfo.addWeightFilter(weightFilter);
            return modeInfo;
        }

        private boolean containsMode(String mode) {
            return this.modeInfoMap.get(mode) != null;
        }

        private ModeInfo getModeInfo(String mode) {
            return this.modeInfoMap.get(mode);
        }

        private void addNewTie(NewTie newTie) {
            this.newTieList.add(newTie);
        }

        private PositionMaxima getMainPositionMaxima(SubsetItem otherSubsetItem, Subset mainSubset) {
            PositionMaxima positionMaxima = this.maximaMap.get(otherSubsetItem.getId());
            if (positionMaxima == null) {
                Junctions mainSubsetJunctions = this.fichotheque.getJunctions(otherSubsetItem, mainSubset);
                positionMaxima = new PositionMaxima();
                for (Junctions.Entry entry : mainSubsetJunctions.getEntryList()) {
                    Junction junction;
                    positionMaxima.checkJunction(junction, (junction = entry.getJunction()).getJunctionKey().getOrder(otherSubsetItem) != 1);
                }
                this.maximaMap.put(otherSubsetItem.getId(), positionMaxima);
            }
            return positionMaxima;
        }
    }

    private static class ModeInfo {
        private final String mode;
        private boolean allWeight = false;
        private Set<Integer> weightSet;

        private ModeInfo(String mode) {
            this.mode = mode;
        }

        private void addWeightFilter(int weightFilter) {
            if (this.allWeight) {
                return;
            }
            if (weightFilter == -1) {
                this.allWeight = true;
            } else {
                if (this.weightSet == null) {
                    this.weightSet = new HashSet<Integer>();
                }
                this.weightSet.add(weightFilter);
            }
        }

        private boolean containsWeight(int weight) {
            if (this.allWeight) {
                return true;
            }
            if (this.weightSet == null) {
                return false;
            }
            return this.weightSet.contains(weight);
        }
    }

    private static class NewTie {
        private final SubsetItem otherSubsetItem;
        private final String mode;
        private int weight;
        private int position1 = 0;
        private int position2 = 0;
        private final boolean mainIsFirst;
        private boolean canceled = false;

        private NewTie(SubsetItem otherSubsetItem, String mode, int weight, boolean mainIsFirst) {
            this.mode = mode;
            this.weight = weight;
            this.mainIsFirst = mainIsFirst;
            this.otherSubsetItem = otherSubsetItem;
        }

        private String getMode() {
            return this.mode;
        }

        private SubsetItem getOtherSubsetItem() {
            return this.otherSubsetItem;
        }

        private void setPositions(Tie currentTie) {
            this.position1 = currentTie.getPosition1();
            this.position2 = currentTie.getPosition2();
        }

        private boolean isCanceled() {
            return this.canceled;
        }

        private void cancelNewTie() {
            this.canceled = true;
        }

        private boolean isMainPositionUndefined() {
            if (this.mainIsFirst) {
                return this.position1 == 0;
            }
            return this.position2 == 0;
        }

        private boolean isOtherPositionUndefined() {
            if (this.mainIsFirst) {
                return this.position2 == 0;
            }
            return this.position1 == 0;
        }

        private void setMainPosition(int position) {
            if (this.mainIsFirst) {
                this.position1 = position;
            } else {
                this.position2 = position;
            }
        }

        private void setMainPosition(Tie currentTie) {
            if (this.mainIsFirst) {
                this.position1 = currentTie.getPosition1();
            } else {
                this.position2 = currentTie.getPosition2();
            }
        }

        private void setOtherPosition(int position) {
            if (this.mainIsFirst) {
                this.position2 = position;
            } else {
                this.position1 = position;
            }
        }
    }

    private static class NewJunction {
        private final SubsetItem otherSubsetItem;
        private final Set<String> removedModeSet = new HashSet<String>();
        private final Map<String, NewTie> newTieMap = new HashMap<String, NewTie>();
        private boolean removeAll = false;

        private NewJunction(SubsetItem otherSubsetItem) {
            this.otherSubsetItem = otherSubsetItem;
        }

        private boolean adNewTie(NewTie newTie) {
            String mode = newTie.getMode();
            if (this.newTieMap.containsKey(mode)) {
                return false;
            }
            this.newTieMap.put(mode, newTie);
            this.removedModeSet.remove(mode);
            return true;
        }

        private void addRemovedMode(String mode) {
            this.removedModeSet.add(mode);
            this.cancelNewTie(mode);
        }

        private void setRemoveAll(boolean removeAll) {
            this.removeAll = removeAll;
        }

        private NewTie getNewTie(String mode) {
            return this.newTieMap.get(mode);
        }

        private void cancelNewTie(String mode) {
            NewTie newTie = this.newTieMap.remove(mode);
            if (newTie != null) {
                newTie.cancelNewTie();
            }
        }

        private boolean isRemoved() {
            return this.removeAll;
        }

        private boolean isCancelled() {
            return this.removedModeSet.isEmpty() && this.newTieMap.isEmpty();
        }

        private void checkCurrentTie(Tie currentTie, short changeType) {
            String mode = currentTie.getMode();
            if (this.removedModeSet.contains(mode)) {
                return;
            }
            NewTie newTie = this.getNewTie(mode);
            if (newTie == null) {
                if (changeType == 1) {
                    this.addRemovedMode(mode);
                }
            } else if (changeType == 4) {
                this.cancelNewTie(mode);
            } else if (changeType == 3) {
                if (currentTie.getWeight() >= newTie.weight) {
                    this.cancelNewTie(mode);
                } else {
                    newTie.setPositions(currentTie);
                }
            } else if (changeType == 2) {
                if (currentTie.getWeight() == newTie.weight) {
                    this.cancelNewTie(mode);
                } else {
                    newTie.setPositions(currentTie);
                }
            } else if (changeType == 1) {
                newTie.setMainPosition(currentTie);
            }
        }

        private JunctionChange toJunctionChange() {
            ArrayList<Tie> tieList = new ArrayList<Tie>();
            for (NewTie newTie : this.newTieMap.values()) {
                if (newTie.isCanceled()) continue;
                Tie tie = JunctionUtils.toTie(newTie.getMode(), newTie.weight, newTie.position1, newTie.position2);
                tieList.add(tie);
            }
            return JunctionChangeBuilder.toJunctionChange(this.removedModeSet, tieList);
        }
    }

    private static class PositionMaxima {
        private final Map<String, PositionMax> maximumMap = new HashMap<String, PositionMax>();

        private PositionMaxima() {
        }

        private void checkJunction(Junction junction, boolean firstPosition) {
            for (Tie tie : junction.getTieList()) {
                PositionMax positionMax = this.maximumMap.get(tie.getMode());
                if (positionMax == null) {
                    positionMax = new PositionMax();
                    this.maximumMap.put(tie.getMode(), positionMax);
                }
                positionMax.checkTie(tie, firstPosition);
            }
        }

        private int getNewPosition(String mode) {
            PositionMax positionMax = this.maximumMap.get(mode);
            if (positionMax == null) {
                positionMax = new PositionMax();
                this.maximumMap.put(mode, positionMax);
            }
            return positionMax.getNewPosition();
        }
    }

    private static class PositionMax {
        private int max = 0;

        private PositionMax() {
        }

        private void checkTie(Tie tie, boolean firstPosition) {
            int pos = firstPosition ? tie.getPosition1() : tie.getPosition2();
            this.max = Math.max(this.max, pos);
        }

        private int getNewPosition() {
            ++this.max;
            return this.max;
        }
    }
}

