/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.metadata.AmountSubfieldKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;

class AmountInfoTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;
    private final Map<ExtendedCurrency, String> listedCurrencyMap = new LinkedHashMap<ExtendedCurrency, String>();

    AmountInfoTokenizer(CorpusField corpusField, SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
        Currencies currencies = corpusField.getCurrencies();
        if (currencies != null) {
            int length = currencies.size();
            for (ExtendedCurrency currency : currencies) {
                this.listedCurrencyMap.put(currency, "");
            }
        }
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItems ficheItems = (FicheItems)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItems == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        switch (this.subfieldKey.getSubtype()) {
            case "amount": {
                AmountItem amountItem = this.getAmount(ficheItems, ((AmountSubfieldKey)this.subfieldKey).getCurrency());
                if (amountItem == null) {
                    return FormatterUtils.EMPTY_TOKENS;
                }
                SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(amountItem);
                String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
                return FormatterUtils.toTokens(value);
            }
            case "others": {
                List<String> others = this.getOthersList(ficheItems, formatSource);
                if (others.isEmpty()) {
                    return FormatterUtils.EMPTY_TOKENS;
                }
                return FormatterUtils.toTokens(others);
            }
        }
        throw new SwitchException("subfieldType = " + this.subfieldKey.getSubtype());
    }

    private AmountItem getAmount(FicheItems ficheItems, ExtendedCurrency currency) {
        int ficheCount = ficheItems.size();
        for (int i = 0; i < ficheCount; ++i) {
            ExtendedCurrency currentCur;
            FicheItem ficheItem = (FicheItem)ficheItems.get(i);
            if (!(ficheItem instanceof AmountItem) || !(currentCur = ((AmountItem)ficheItem).getCurrency()).equals(currency)) continue;
            return (AmountItem)ficheItem;
        }
        return null;
    }

    private List<String> getOthersList(FicheItems ficheItems, FormatSource formatSource) {
        ArrayList<String> result = new ArrayList<String>();
        int ficheCount = ficheItems.size();
        for (int i = 0; i < ficheCount; ++i) {
            AmountItem amountItem;
            FicheItem ficheItem = (FicheItem)ficheItems.get(i);
            if (!(ficheItem instanceof AmountItem) || this.listedCurrencyMap.containsKey((amountItem = (AmountItem)ficheItem).getCurrency())) continue;
            SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(ficheItem);
            String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
            result.add(value);
        }
        return result;
    }
}

