/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.ExistingNameException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.addenda.VersionInfo;
import net.fichotheque.addenda.metadata.AddendaMetadataEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.impl.AddendaDataSource;
import net.fichotheque.impl.AddendaMetadataImpl;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.utils.AddendaUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.primitives.FileLength;

public class AddendaImpl
implements Addenda {
    private final SubsetKey addendaKey;
    private final FichothequeImpl fichotheque;
    private AddendaMetadataImpl addendaMetadata;
    private int availableId = 1;
    private List<SubsetItem> cacheSubsetItemList;
    private List<Document> cacheList;
    private final Map<String, DocumentImpl> documentByBasenameMap = new HashMap<String, DocumentImpl>();
    private final Map<Integer, DocumentImpl> itemMap = new HashMap<Integer, DocumentImpl>();

    private AddendaImpl(SubsetKey addendaKey, FichothequeImpl fichotheque) {
        this.addendaKey = addendaKey;
        this.fichotheque = fichotheque;
    }

    static InitEditor fromInit(SubsetKey addendaKey, FichothequeImpl fichotheque, FichothequeImpl.InitEditor fichothequeInitEditor) {
        AddendaImpl addenda = new AddendaImpl(addendaKey, fichotheque);
        return new InitEditor(addenda, fichothequeInitEditor);
    }

    static AddendaImpl fromNew(SubsetKey addendaKey, FichothequeImpl fichotheque) {
        AddendaImpl addenda = new AddendaImpl(addendaKey, fichotheque);
        addenda.addendaMetadata = AddendaMetadataImpl.fromNew(addenda);
        return addenda;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    @Override
    public Metadata getMetadata() {
        return this.addendaMetadata;
    }

    @Override
    public Document getDocumentById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public Document getDocumentByBasename(String basename) {
        return this.documentByBasenameMap.get(basename);
    }

    @Override
    public List<Document> getDocumentList() {
        List<Document> result = this.cacheList;
        if (result == null) {
            result = this.initDocumentList();
        }
        return result;
    }

    @Override
    public SubsetKey getSubsetKey() {
        return this.addendaKey;
    }

    @Override
    public SubsetItem getSubsetItemById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public List<SubsetItem> getSubsetItemList() {
        List<SubsetItem> list = this.cacheSubsetItemList;
        if (list == null) {
            list = this.initSubsetItemList();
        }
        return list;
    }

    @Override
    public List<Corpus> getSatelliteCorpusList() {
        return FichothequeUtils.EMPTY_CORPUSLIST;
    }

    AddendaEditorImpl getAddendaEditor(FichothequeEditor fichothequeEditor) {
        return new AddendaEditorImpl(fichothequeEditor);
    }

    private AddendaDataSource getAddendaDataSource() {
        return this.fichotheque.getFichothequeDataSource().getAddendaDataSource();
    }

    private synchronized boolean innerRemoveDocument(Document document) {
        this.testDocument(document);
        if (!this.fichotheque.isRemoveable(document)) {
            return false;
        }
        this.documentByBasenameMap.remove(document.getBasename());
        this.itemMap.remove(document.getId());
        this.clearCache();
        return true;
    }

    private boolean innerRemoveVersion(Document document, String extension) {
        DocumentImpl implDocument = this.testDocument(document);
        return implDocument.deleteVersion(extension);
    }

    private synchronized Document innerCreateDocument(int id, Collection<VersionInfo> versionInfos) throws ExistingIdException {
        if (id < 1) {
            id = this.availableId;
        } else if (this.itemMap.containsKey(id)) {
            throw new ExistingIdException();
        }
        DocumentImpl document = new DocumentImpl(id);
        this.itemMap.put(id, document);
        this.documentByBasenameMap.put(document.getBasename(), document);
        if (versionInfos != null) {
            document.initVersionList(versionInfos);
        }
        this.availableId = Math.max(this.availableId, id + 1);
        this.clearCache();
        return document;
    }

    private boolean innerSetBasename(Document document, String newName) throws ExistingNameException, ParseException {
        if (!AddendaUtils.testBasename(newName)) {
            throw new ParseException("wrong basename", 0);
        }
        DocumentImpl bdfimpldoc = this.testDocument(document);
        String oldName = bdfimpldoc.getBasename();
        if (oldName.equals(newName)) {
            return false;
        }
        if (this.documentByBasenameMap.containsKey(newName)) {
            throw new ExistingNameException();
        }
        this.documentByBasenameMap.remove(oldName);
        bdfimpldoc.setBasename(newName);
        this.documentByBasenameMap.put(newName, bdfimpldoc);
        return true;
    }

    private void innerUpdateVersion(Document document, String extension, InputStream inputStream) throws ParseException, IOException {
        if (!AddendaUtils.testExtension(extension)) {
            throw new ParseException("wrong extension", 0);
        }
        DocumentImpl bdfimpldoc = this.testDocument(document);
        bdfimpldoc.saveVersion(extension, inputStream);
    }

    private void clearCache() {
        this.cacheSubsetItemList = null;
        this.cacheList = null;
    }

    private synchronized List<SubsetItem> initSubsetItemList() {
        TreeMap<Integer, DocumentImpl> sortedMap = new TreeMap<Integer, DocumentImpl>();
        sortedMap.putAll(this.itemMap);
        List<SubsetItem> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Document[sortedMap.size()]));
        this.cacheSubsetItemList = list;
        return list;
    }

    private synchronized List<Document> initDocumentList() {
        TreeMap<Integer, DocumentImpl> sortedMap = new TreeMap<Integer, DocumentImpl>();
        sortedMap.putAll(this.itemMap);
        List<Document> list = AddendaUtils.wrap(sortedMap.values().toArray(new Document[sortedMap.size()]));
        this.cacheList = list;
        return list;
    }

    private DocumentImpl testDocument(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("document argument cannot be null");
        }
        try {
            DocumentImpl bdfimpl = (DocumentImpl)document;
            if (bdfimpl.getAddenda() != this) {
                throw new IllegalArgumentException("document argument does not come from this documentSubse");
            }
            return bdfimpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("document argument does not come from this documentSubset");
        }
    }

    static class InitEditor
    implements AddendaEditor {
        private final AddendaImpl addenda;
        private final FichothequeImpl.InitEditor fichothequeInitEditor;
        private final AddendaMetadataImpl.InitEditor metadataInitEditor;

        private InitEditor(AddendaImpl addenda, FichothequeImpl.InitEditor fichothequeInitEditor) {
            this.addenda = addenda;
            this.fichothequeInitEditor = fichothequeInitEditor;
            this.metadataInitEditor = AddendaMetadataImpl.fromInit(this);
            addenda.addendaMetadata = (AddendaMetadataImpl)this.metadataInitEditor.getMetadata();
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeInitEditor;
        }

        @Override
        public Addenda getAddenda() {
            return this.addenda;
        }

        @Override
        public AddendaMetadataEditor getAddendaMetadataEditor() {
            return this.metadataInitEditor;
        }

        @Override
        public boolean removeDocument(Document document) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean removeVersion(Document document, String extension) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public Document createDocument(int id, Collection<VersionInfo> versionInfos) throws ExistingIdException {
            return this.addenda.innerCreateDocument(id, versionInfos);
        }

        @Override
        public boolean setBasename(Document document, String newName) throws ExistingNameException, ParseException {
            return this.addenda.innerSetBasename(document, newName);
        }

        @Override
        public void saveVersion(Document document, String extension, InputStream inputStream) throws ParseException, IOException {
            throw new UnsupportedOperationException("Not during init");
        }
    }

    class AddendaEditorImpl
    implements AddendaEditor {
        private final FichothequeEditor fichothequeEditor;
        private final Set<Integer> changedDocumentSet = new HashSet<Integer>();
        private final Set<Integer> removedDocumentSet = new HashSet<Integer>();
        private AddendaMetadataEditor addendaMetadataEditor;
        private boolean metadataChanged = false;

        private AddendaEditorImpl(FichothequeEditor fichothequeEditor) {
            this.fichothequeEditor = fichothequeEditor;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeEditor;
        }

        @Override
        public Addenda getAddenda() {
            return AddendaImpl.this;
        }

        @Override
        public AddendaMetadataEditor getAddendaMetadataEditor() {
            if (this.addendaMetadataEditor == null) {
                this.addendaMetadataEditor = AddendaImpl.this.addendaMetadata.getAddendaMetadataEditor(this);
            }
            return this.addendaMetadataEditor;
        }

        @Override
        public boolean removeDocument(Document document) {
            int id = document.getId();
            boolean done = AddendaImpl.this.innerRemoveDocument(document);
            if (done) {
                this.removedDocumentSet.add(id);
            }
            return done;
        }

        @Override
        public boolean removeVersion(Document document, String extension) {
            return AddendaImpl.this.innerRemoveVersion(document, extension);
        }

        @Override
        public Document createDocument(int id, Collection<VersionInfo> versionInfos) throws ExistingIdException {
            Document document = AddendaImpl.this.innerCreateDocument(id, versionInfos);
            this.addDocumentChange(document.getId());
            return document;
        }

        @Override
        public boolean setBasename(Document document, String newName) throws ExistingNameException, ParseException {
            boolean done = AddendaImpl.this.innerSetBasename(document, newName);
            if (done) {
                this.addDocumentChange(document.getId());
            }
            return done;
        }

        @Override
        public void saveVersion(Document document, String extension, InputStream inputStream) throws ParseException, IOException {
            AddendaImpl.this.innerUpdateVersion(document, extension, inputStream);
        }

        void addDocumentChange(int id) {
            this.changedDocumentSet.add(id);
        }

        void setMetadataChange() {
            this.metadataChanged = true;
        }

        void saveChanges() {
            EditOrigin editOrigin = this.fichothequeEditor.getEditOrigin();
            AddendaDataSource addendaDataSource = AddendaImpl.this.getAddendaDataSource();
            if (this.metadataChanged) {
                addendaDataSource.saveMetadata(AddendaImpl.this, editOrigin);
                this.metadataChanged = false;
            }
            for (Integer id : this.changedDocumentSet) {
                Document document = AddendaImpl.this.getDocumentById(id);
                if (document == null) continue;
                addendaDataSource.saveDocument(document, editOrigin);
            }
            this.changedDocumentSet.clear();
            for (Integer id : this.removedDocumentSet) {
                addendaDataSource.removeDocument(AddendaImpl.this, id, editOrigin);
            }
            this.removedDocumentSet.clear();
        }
    }

    private class DocumentImpl
    extends AbstractSubsetItem
    implements Document {
        private final int id;
        private String basename;
        private final List<VersionImpl> versionList = new ArrayList<VersionImpl>();
        private List<Version> cacheList;

        private DocumentImpl(int id) {
            this.id = id;
            this.basename = "_" + id;
        }

        @Override
        public Subset getSubset() {
            return AddendaImpl.this;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getBasename() {
            return this.basename;
        }

        @Override
        public List<Version> getVersionList() {
            List<Version> result = this.cacheList;
            if (result == null) {
                result = this.initCacheList();
            }
            return result;
        }

        @Override
        public Version getVersionByExtension(String extension) {
            int size = this.versionList.size();
            for (int i = 0; i < size; ++i) {
                Version version = this.versionList.get(i);
                if (!version.getExtension().equals(extension)) continue;
                return version;
            }
            return null;
        }

        private void setBasename(String basename) {
            this.basename = basename;
        }

        private synchronized void initVersionList(Collection<VersionInfo> versionInfos) {
            TreeMap<String, VersionImpl> versionMap = new TreeMap<String, VersionImpl>();
            for (VersionInfo versionInfo : versionInfos) {
                VersionImpl version = new VersionImpl(versionInfo);
                versionMap.put(version.getExtension(), version);
            }
            this.versionList.addAll(versionMap.values());
            this.clearCache();
        }

        private synchronized void saveVersion(String extension, InputStream inputStream) throws IOException {
            VersionInfo versionInfo = AddendaImpl.this.getAddendaDataSource().saveVersion(this, extension, inputStream);
            int size = this.versionList.size();
            boolean done = false;
            for (int i = 0; i < size; ++i) {
                VersionImpl other = this.versionList.get(i);
                int comp = other.getExtension().compareTo(extension);
                if (comp == 0) {
                    done = true;
                    other.update(versionInfo);
                    break;
                }
                if (comp <= 0) continue;
                done = true;
                this.versionList.add(i, new VersionImpl(versionInfo));
                break;
            }
            if (!done) {
                this.versionList.add(new VersionImpl(versionInfo));
            }
            this.clearCache();
        }

        private synchronized boolean deleteVersion(String extension) {
            if (this.versionList.size() == 1) {
                return false;
            }
            AddendaImpl.this.getAddendaDataSource().deleteVersion(this, extension);
            Iterator<VersionImpl> it = this.versionList.iterator();
            while (it.hasNext()) {
                VersionImpl version = it.next();
                if (!version.getExtension().equals(extension)) continue;
                it.remove();
                break;
            }
            this.clearCache();
            return true;
        }

        private synchronized List<Version> initCacheList() {
            if (this.cacheList != null) {
                return this.cacheList;
            }
            List<Version> list = AddendaUtils.wrap(this.versionList.toArray(new Version[this.versionList.size()]));
            this.cacheList = list;
            return list;
        }

        private void clearCache() {
            this.cacheList = null;
        }

        private class VersionImpl
        implements Version {
            private final String extension;
            private FileLength fileLength;
            private String md5Checksum;

            private VersionImpl(VersionInfo versionInfo) {
                this.extension = versionInfo.getExtension();
                this.setFileLength(versionInfo.getLength());
                this.md5Checksum = versionInfo.getMd5Checksum();
            }

            @Override
            public Document getDocument() {
                return DocumentImpl.this;
            }

            @Override
            public String getExtension() {
                return this.extension;
            }

            @Override
            public FileLength getFileLength() {
                return this.fileLength;
            }

            @Override
            public String getMd5Checksum() {
                return this.md5Checksum;
            }

            @Override
            public InputStream getInputStream() {
                if (this.fileLength.getValue() == 0L) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                return AddendaImpl.this.getAddendaDataSource().getInputStream(DocumentImpl.this, this.extension);
            }

            @Override
            public void linkTo(Path destination, boolean symbolicLink) throws IOException {
                AddendaImpl.this.getAddendaDataSource().linkTo(DocumentImpl.this, this.extension, destination, symbolicLink);
            }

            private void update(VersionInfo versionInfo) {
                this.setFileLength(versionInfo.getLength());
                this.md5Checksum = versionInfo.getMd5Checksum();
            }

            private void setFileLength(long fln) {
                this.fileLength = fln < 0L ? FileLength.EMPTY_FILELENGTH : new FileLength(fln);
            }
        }
    }
}

