/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.synthesis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.text.StringUtils;

public class RedacteurSynthesis {
    public static final String A_ADMIN_LEVEL = "A";
    public static final String B_USER_LEVEL = "B";
    public static final String C_READONLY_LEVEL = "C";
    public static final String D_INACTIVE_LEVEL = "D";
    private final String login;
    private final Map<String, FichothequeStatus> statusMap = new HashMap<String, FichothequeStatus>();
    private final Map<String, Occurrence> nameOccurrenceMap = new HashMap<String, Occurrence>();
    private final Map<String, Occurrence> emailOccurrenceMap = new HashMap<String, Occurrence>();
    private Occurrence maxNameOccurrence = null;
    private Occurrence maxEmailOccurrence = null;

    public RedacteurSynthesis(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public String getCompleteName() {
        if (this.maxNameOccurrence != null) {
            return this.maxNameOccurrence.text;
        }
        return "";
    }

    public String getEmail() {
        if (this.maxEmailOccurrence != null) {
            return this.maxEmailOccurrence.text;
        }
        return "";
    }

    public List<String> getOtherNameList() {
        if (this.nameOccurrenceMap.size() < 2) {
            return StringUtils.EMPTY_STRINGLIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Occurrence nameOccurrence : this.nameOccurrenceMap.values()) {
            if (nameOccurrence.equals(this.maxNameOccurrence)) continue;
            result.add(nameOccurrence.text);
        }
        return result;
    }

    public List<String> getOtherEmailList() {
        if (this.emailOccurrenceMap.size() < 2) {
            return StringUtils.EMPTY_STRINGLIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Occurrence emailOccurrence : this.emailOccurrenceMap.values()) {
            if (emailOccurrence.equals(this.maxEmailOccurrence)) continue;
            result.add(emailOccurrence.text);
        }
        return result;
    }

    public void addRedacteur(Redacteur redacteur, String fichothequeName, boolean admin) {
        String level;
        if (admin) {
            level = A_ADMIN_LEVEL;
        } else {
            switch (redacteur.getStatus()) {
                case "inactive": {
                    level = D_INACTIVE_LEVEL;
                    break;
                }
                case "readonly": {
                    level = C_READONLY_LEVEL;
                    break;
                }
                default: {
                    level = B_USER_LEVEL;
                }
            }
        }
        Occurrence nameOccurrence = this.getNameOccurrence(redacteur, fichothequeName);
        Occurrence emailOccurrence = this.getEmailOccurrence(redacteur, fichothequeName);
        FichothequeStatus fichothequeStatus = new FichothequeStatus(fichothequeName, level, nameOccurrence, emailOccurrence);
        this.statusMap.put(fichothequeName, fichothequeStatus);
    }

    public FichothequeStatus getFichothequeStatus(String fichothequeName) {
        FichothequeStatus fichothequeStatus = this.statusMap.get(fichothequeName);
        if (fichothequeStatus == null) {
            return null;
        }
        return fichothequeStatus;
    }

    private Occurrence getNameOccurrence(Redacteur redacteur, String fichothequeName) {
        String completeName = redacteur.getPersonCore().toStandardStyle();
        Occurrence nameOccurrence = this.nameOccurrenceMap.get(completeName);
        if (nameOccurrence == null) {
            nameOccurrence = new Occurrence(completeName);
            this.nameOccurrenceMap.put(completeName, nameOccurrence);
        }
        nameOccurrence.add(fichothequeName);
        if (this.maxNameOccurrence == null) {
            this.maxNameOccurrence = nameOccurrence;
        } else if (nameOccurrence.size() > this.maxNameOccurrence.size()) {
            this.maxNameOccurrence = nameOccurrence;
        }
        return nameOccurrence;
    }

    private Occurrence getEmailOccurrence(Redacteur redacteur, String fichothequeName) {
        EmailCore emailCore = redacteur.getEmailCore();
        String completeEmail = emailCore != null ? emailCore.getAddrSpec() : "";
        Occurrence emailOccurrence = this.emailOccurrenceMap.get(completeEmail);
        if (emailOccurrence == null) {
            emailOccurrence = new Occurrence(completeEmail);
            this.emailOccurrenceMap.put(completeEmail, emailOccurrence);
        }
        emailOccurrence.add(fichothequeName);
        if (this.maxEmailOccurrence == null) {
            this.maxEmailOccurrence = emailOccurrence;
        } else if (emailOccurrence.size() > this.maxEmailOccurrence.size()) {
            this.maxEmailOccurrence = emailOccurrence;
        }
        return emailOccurrence;
    }

    private static class Occurrence {
        private final String text;
        private final Set<String> fichothequeNameSet = new HashSet<String>();

        private Occurrence(String name) {
            this.text = name;
        }

        private void add(String fichothequeName) {
            this.fichothequeNameSet.add(fichothequeName);
        }

        private int size() {
            return this.fichothequeNameSet.size();
        }
    }

    public class FichothequeStatus {
        private final String fichothequeName;
        private final String level;
        private final Occurrence nameOccurrence;
        private final Occurrence emailOccurrence;

        private FichothequeStatus(String fichothequeName, String level, Occurrence nameOccurrence, Occurrence emailOccurrence) {
            this.fichothequeName = fichothequeName;
            this.level = level;
            this.nameOccurrence = nameOccurrence;
            this.emailOccurrence = emailOccurrence;
        }

        public String getLevel() {
            return this.level;
        }

        public boolean hasSpecificName() {
            return !this.nameOccurrence.equals(RedacteurSynthesis.this.maxNameOccurrence);
        }

        public String getSpecificName() {
            return this.nameOccurrence.text;
        }

        public boolean hasSpecificEmail() {
            return !this.emailOccurrence.equals(RedacteurSynthesis.this.maxEmailOccurrence);
        }

        public String getSpecificEmail() {
            return this.emailOccurrence.text;
        }
    }
}

