/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.compilers;

import fr.exemole.bdfserver.tools.exportation.transformation.compilers.FrameDim;
import fr.exemole.bdfserver.tools.exportation.transformation.compilers.PropertyPart;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.fichotheque.album.Illustration;
import net.mapeadores.opendocument.transform.PictureHandler;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

class ImageXMLPart
extends XMLPart {
    private final PictureHandler pictureHandler;
    private final Set<String> usedNameSet = new HashSet<String>();

    ImageXMLPart(XMLWriter xmlWriter, PictureHandler pictureHandler) {
        super(xmlWriter);
        this.pictureHandler = pictureHandler;
    }

    public void write(Illustration illustration, PropertyPart propertyPart) throws IOException {
        String href = this.pictureHandler.checkHref("bdf://this/illustrations/" + illustration.getSubsetName() + "-" + illustration.getId());
        FrameDim frameDim = FrameDim.build(illustration, propertyPart);
        String drawName = this.checkName(illustration.getGlobalId());
        this.startOpenTag("draw:frame");
        this.addAttribute("draw:name", drawName);
        this.addAttribute("draw:style-name", "FbeIllustration");
        this.addAttribute("text:anchor-type", "as-char");
        this.addAttribute("svg:width", frameDim.getWidth());
        this.addAttribute("svg:height", frameDim.getHeight());
        this.addAttribute("draw:z-index", "0");
        this.endOpenTag();
        this.startOpenTag("draw:image");
        this.addAttribute("xlink:href", href);
        this.addAttribute("xlink:type", "simple");
        this.addAttribute("xlink:show", "embed");
        this.addAttribute("xlink:actuate", "onLoad");
        this.closeEmptyTag();
        this.closeTag("draw:frame");
    }

    private String checkName(String name) {
        String newName;
        if (!this.usedNameSet.contains(name)) {
            this.usedNameSet.add(name);
            return name;
        }
        int suppNumber = 2;
        while (this.usedNameSet.contains(newName = name + "_" + suppNumber)) {
            ++suppNumber;
        }
        this.usedNameSet.add(newName);
        return newName;
    }
}

