/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AddToFichothequeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "AddToFichotheque";

    public AddToFichothequeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        this.initCentralSphere();
        this.initCentralUser();
        this.initBdfServer(true);
        BdfServer bdfServer = this.getBdfServer();
        synchronized (bdfServer) {
            try (EditSession editSession = this.newEditSession(COMMAND_NAME);){
                SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.centralSphere.getSphereKey());
                Redacteur newRedacteur = this.createRedacteur(sphereEditor, this.centralUser);
                sphereEditor.setPerson(newRedacteur, this.centralUser.getPerson());
                sphereEditor.setEmail(newRedacteur, this.centralUser.getEmail());
                this.bdfServer.getPasswordManager().setEncryptedPassword(newRedacteur.getGlobalId(), this.centralUser.getEncryptedPassword());
                this.changeStatus(newRedacteur, sphereEditor, editSession);
            }
        }
        return this.done("_ done.sphere.redacteurcreation", this.centralUser.getLogin());
    }

    private Redacteur createRedacteur(SphereEditor sphereEditor, CentralUser centralUser) throws ErrorMessageException {
        try {
            return sphereEditor.createRedacteur(-1, centralUser.getLogin());
        }
        catch (ExistingIdException eie) {
            throw BdfErrors.error("_ error.existing.login", centralUser.getLogin());
        }
        catch (ParseException pe) {
            throw new ShouldNotOccurException("Login from central user");
        }
    }
}

