/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.corpus;

import fr.exemole.bdfserver.json.HistoryJson;
import java.io.IOException;
import java.util.Collection;
import net.fichotheque.history.HistoryUnit;
import net.fichotheque.history.JunctionHistory;
import net.fichotheque.junction.JunctionKey;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class JunctionHistoryArrayProperty
implements JsonProperty {
    private final Collection<JunctionHistory> junctionHistories;

    public JunctionHistoryArrayProperty(Collection<JunctionHistory> junctionHistories) {
        this.junctionHistories = junctionHistories;
    }

    @Override
    public String getName() {
        return "junctionHistoryArray";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.array();
        for (JunctionHistory junctionHistory : this.junctionHistories) {
            JunctionKey junctionKey = junctionHistory.getJunctionKey();
            HistoryUnit junctionUnit = junctionHistory.getJunctionUnit();
            jw.object();
            jw.key("thesaurus").value(junctionKey.getSubsetKey2().getSubsetName());
            jw.key("id").value(junctionKey.getId2());
            jw.key("deleted").value(junctionHistory.isDeleted());
            if (!junctionUnit.isEmpty()) {
                jw.key("lastRevision");
                jw.object();
                HistoryJson.properties(jw, junctionUnit.getMostRecentRevision(), null);
                jw.endObject();
            }
            jw.endObject();
        }
        jw.endArray();
    }
}

