/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.roles.SatelliteOpportunities;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.SatelliteTree;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlUtils;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHandler;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import fr.exemole.bdfserver.tools.ui.components.UiSummary;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.html.HA;

public class FicheResultHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final FicheMeta ficheMeta;
    private final FicheResultHandler ficheResultHandler;

    public FicheResultHtmlProducer(BdfParameters bdfParameters, FicheResultHandler ficheResultHandler) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.ficheResultHandler = ficheResultHandler;
        this.ficheMeta = ficheResultHandler.getFicheMeta();
        this.addJsLib(BdfJsLibs.SHORTCUT_INIT);
        this.addJsLib(FicheJsLibs.FICHEFRAME_INIT);
        this.addThemeCss("edition.css");
    }

    @Override
    public void printHtml() {
        String fichePath = this.ficheResultHandler.getFicheLink("html");
        this.start();
        this.SCRIPT().__jsObject("var", "RESULT_ITEM", this.ficheResultHandler.getResultItemObject()).__jsObject("Ficheframe.ARGS", this.ficheResultHandler.getFicheframeArgsObject())._SCRIPT();
        this.DIV("edition-Page edition-result-Page").__(EditionHtmlUtils.printFicheframeFieldedit(this)).__(this.printCommandMessageUnit()).NAV("edition-Toolbar").__(this.printToolbar()).__(EditionHtmlUtils.printFicheframeToolbar(this))._NAV().IFRAME(HA.name("ficheframe").src(fichePath).classes("edition-Unit").attr("data-shortcut-role", "iframe").attr("data-ficheframe-role", "iframe")).P().A(HA.href(fichePath)).__localize("_ link.fiches.fiche_long")._A()._P()._IFRAME()._DIV();
        this.end();
    }

    private boolean printToolbar() {
        switch (this.ficheResultHandler.getToolbarType()) {
            case 2: {
                return this.printStandaloneToolbar();
            }
            case 3: {
                return this.printOverlayToolbar();
            }
        }
        return this.printDefaultToolbar();
    }

    private boolean printStandaloneToolbar() {
        this.__(this.editLink()).__(this.displayLink()).__(this.odtLink());
        return true;
    }

    private boolean printOverlayToolbar() {
        this.__(this.editLink()).__(this.displayLink()).__(this.odtLink()).SPAN("global-Glue")._SPAN().__(FicheResultHandler.OVERLAY_CLOSE_BUTTON);
        return true;
    }

    private boolean printDefaultToolbar() {
        SatelliteOpportunities satelliteOpportunities = BdfServerUtils.getSatelliteOpportunities(this.ficheMeta, this.permissionSummary);
        boolean withSatellites = this.hasSatellites(satelliteOpportunities);
        UiSummary uiSummary = UiUtils.summarize(this.bdfServer.getUiManager().getMainUiComponents(this.ficheMeta.getCorpus()));
        this.__(FicheResultHandler.REFRESH_BUTTON).__(this.editLink()).__(this.addendaLink(uiSummary)).__(this.displayLink()).__(this.odtLink()).__(this.printSatelliteButton(withSatellites, satelliteOpportunities));
        return true;
    }

    private boolean hasSatellites(SatelliteOpportunities satelliteOpportunities) {
        if (satelliteOpportunities.onlyReadAllowed()) {
            return false;
        }
        return !satelliteOpportunities.getEntryList().isEmpty();
    }

    private boolean printSatelliteButton(boolean withSatellites, SatelliteOpportunities satelliteOpportunities) {
        if (!withSatellites) {
            return false;
        }
        this.DETAILS("tools-Details").SUMMARY("edition-result-Summary").SPAN("edition-result-SummaryContent").__localize("_ link.global.satellites")._SPAN()._SUMMARY().__(SatelliteTree.init(this.workingLang, this.formatLocale).current(this.ficheMeta, satelliteOpportunities))._DETAILS();
        return true;
    }

    private Button editLink() {
        String editionHref = this.ficheResultHandler.getEditHref();
        return Button.link().href(editionHref).action("action-FicheEdit").textL10nObject("_ link.edition.fichechange_short").tooltipMessage("_ link.edition.fichechange_back").shortcutKey("F2").shortcutTooltip("F2");
    }

    private Button addendaLink(UiSummary uiSummary) {
        if (!uiSummary.withAddendaInclude()) {
            return null;
        }
        String addendaHref = BH.domain("corpus").page("fiche-addenda").subsetItem(this.ficheMeta).toString();
        return Button.link().href(addendaHref).action("action-FicheAddenda").textL10nObject("_ link.edition.ficheaddenda_short").tooltipMessage("_ link.edition.ficheaddenda_long");
    }

    private Button displayLink() {
        String fichePath = this.ficheResultHandler.getFicheLink("html");
        return Button.link().href(fichePath).action("action-FicheDisplay").textL10nObject("_ link.global.display").tooltipMessage("_ link.fiches.fiche_blank").target("_blank");
    }

    private Button odtLink() {
        String fichePath = this.ficheResultHandler.getFicheLink("odt");
        return Button.link().href(fichePath).action("action-Odt").textMessage("_ link.global.version", "ODT");
    }
}

