/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.JsObject;

public class FicheResultHandler {
    public static final Button REFRESH_BUTTON = Button.link(BH.domain("main").page("fiches").param("reload", "1").toString()).target("List").action("action-Refresh").textL10nObject("_ link.global.refresh").tooltipMessage("_ link.main.fiches_update");
    public static final Button OVERLAY_CLOSE_BUTTON = Button.button().style("link").textL10nObject("_ link.global.close").action("action-Close").buttonId("button_overlay_close").shortcutKey("Escape").shortcutTooltip("Esc");
    public static final int DEFAULT_TYPE = 1;
    public static final int STANDALONE_TYPE = 2;
    public static final int OVERLAY_TYPE = 3;
    private final FicheMeta ficheMeta;
    private final String options;
    private final String gotoValue;

    public FicheResultHandler(FicheMeta ficheMeta, String options, String gotoValue) {
        this.ficheMeta = ficheMeta;
        this.options = options;
        this.gotoValue = gotoValue;
    }

    public FicheMeta getFicheMeta() {
        return this.ficheMeta;
    }

    public String getOptions() {
        return this.options;
    }

    public String getGotoValue() {
        return this.gotoValue;
    }

    public int getToolbarType() {
        if (this.options == null) {
            return 1;
        }
        if (this.options.contains("standalone")) {
            return 2;
        }
        if (this.options.contains("overlay")) {
            return 3;
        }
        return 1;
    }

    public String getFicheLink(String type) {
        return BdfInstructionUtils.getFicheGetLink(this.ficheMeta, type);
    }

    public String getEditHref() {
        return BH.domain("edition").page("fiche-change").subsetItem(this.ficheMeta).param("page-result-options", this.options).toString();
    }

    public JsObject getResultItemObject() {
        return JsObject.init().put("type", "fiche").put("corpus", this.ficheMeta.getCorpus().getSubsetName()).put("id", this.ficheMeta.getId());
    }

    public JsObject getFicheframeArgsObject() {
        return JsObject.init().put("goto", this.gotoValue).put("pageResultOptions", this.options);
    }

    public static FicheResultHandler build(FicheMeta ficheMeta, RequestHandler requestHandler) {
        String options = requestHandler.getTrimedParameter("page-options");
        if (options.isEmpty()) {
            options = null;
        }
        return new FicheResultHandler(ficheMeta, options, requestHandler.getTrimedParameter("goto"));
    }
}

