/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.AttributesText;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.JunctionSelection;
import fr.exemole.bdfserver.html.consumers.MetadataPhrases;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import java.util.List;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumConstants;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadata;
import net.fichotheque.junction.JunctionsBySubset;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlPrinter;

public final class AlbumCommandBoxUtils {
    private static final SelectOption[] DIMTYPE_OPTIONS = new SelectOption[]{SelectOption.init("fixed-width").textL10nObject("_ label.album.albumdimtype_fixedwidth"), SelectOption.init("fixed-height").textL10nObject("_ label.album.albumdimtype_fixedheight"), SelectOption.init("max-width").textL10nObject("_ label.album.albumdimtype_maxwidth"), SelectOption.init("max-height").textL10nObject("_ label.album.albumdimtype_maxheight"), SelectOption.init("max-dim").textL10nObject("_ label.album.albumdimtype_maxdim")};

    private AlbumCommandBoxUtils() {
    }

    public static boolean printAlbumCreationBox(HtmlPrinter hp, CommandBox commandBox) {
        commandBox = commandBox.derive("AlbumCreation", "_ ALB-01").actionCssClass("action-New").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.album.albumcreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.album.newalbumname", hp.name("newalbum").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printAlbumPhrasesBox(HtmlPrinter hp, CommandBox commandBox, Album album, BdfServer bdfServer) {
        AlbumMetadata albumMetadata = album.getAlbumMetadata();
        commandBox = commandBox.derive("AlbumIntitule", "_ ALB-02").__(CommandBoxUtils.insert(album)).actionCssClass("action-Labels").submitLocKey("_ submit.album.albumphrases");
        hp.__start(commandBox).__(MetadataPhrases.init(albumMetadata, bdfServer.getLangConfiguration().getWorkingLangs(), "_ label.album.title").populateFromAttributes(album).addExtensionPhraseDefList(bdfServer)).__end(commandBox);
        return true;
    }

    public static boolean printAlbumRemoveBox(HtmlPrinter hp, CommandBox commandBox, Album album) {
        commandBox = commandBox.derive("AlbumRemove", "_ ALB-10").__(CommandBoxUtils.insert(album)).actionCssClass("action-Delete").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.album.albumremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printAlbumAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Album album) {
        commandBox = commandBox.derive("AlbumAttributeChange", "_ ALB-09").__(CommandBoxUtils.insert(album)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(album.getAlbumMetadata().getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printAlbumDimChangeBox(HtmlPrinter hp, CommandBox commandBox, AlbumDim albumDim) {
        ResizeInfo resizeInfo = albumDim.getResizeInfo();
        String dimType = albumDim.getDimType();
        commandBox = commandBox.derive("AlbumDimChange", "_ ALB-04").__(CommandBoxUtils.insert(albumDim)).submitLocKey("_ submit.album.albumdimchange");
        hp.__start(commandBox).__(Grid.START).__(() -> {
            if (AlbumConstants.needWidth(dimType)) {
                hp.__(Grid.textInputRow("_ label.album.width", hp.name("albumdimwidth").value(String.valueOf(resizeInfo.getWidth())).size("15")));
            }
        }).__(() -> {
            if (AlbumConstants.needHeight(dimType)) {
                hp.__(Grid.textInputRow("_ label.album.height", hp.name("albumdimheight").value(String.valueOf(resizeInfo.getHeight())).size("15")));
            }
        }).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printAlbumDimRemoveBox(HtmlPrinter hp, CommandBox commandBox, AlbumDim albumDim) {
        commandBox = commandBox.derive("AlbumDimRemove", "_ ALB-05").__(CommandBoxUtils.insert(albumDim)).submitLocKey("_ submit.album.albumdimremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printAlbumDimCreationBox(HtmlPrinter hp, CommandBox commandBox, Album album) {
        commandBox = commandBox.derive("AlbumDimCreation", "_ ALB-03").__(CommandBoxUtils.insert(album)).submitLocKey("_ submit.album.albumdimcreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.album.newalbumdim", hp.name("newalbumdim").size("30").populate(InputPattern.TECHNICAl_UNDERSCORE).required(true))).__(Grid.selectRow((Object)"_ label.album.albumdimtype", hp.name("albumdimtype"), SelectOption.consumer(DIMTYPE_OPTIONS, (Object)"fixed-width"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printIllustrationFileUploadBox(HtmlPrinter hp, CommandBox commandBox, Album album, Illustration illustration) {
        Object insertObject = illustration != null ? illustration : album;
        commandBox = commandBox.derive("IllustrationFileUpload", "_ ALB-07").multipart(true).__(CommandBoxUtils.insert(insertObject)).submitLocKey("_ submit.album.illustrationfileupload");
        hp.__start(commandBox).__(Grid.START).__(Grid.fileInputRow("_ label.album.illustrationfile", hp.name("file").size("40").classes("global-FileInput"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printIllustrationAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Illustration illustration) {
        commandBox = commandBox.derive("IllustrationAttributeChange", "_ ALB-12").__(CommandBoxUtils.insert(illustration)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(illustration.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printIllustrationRemoveBox(HtmlPrinter hp, CommandBox commandBox, Illustration illustration) {
        commandBox = commandBox.derive("IllustrationRemove", "_ ALB-11").__(CommandBoxUtils.insert(illustration)).actionCssClass("action-Delete").submitLocKey("_ submit.album.illustrationremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printJunctionRemoveBox(HtmlPrinter hp, CommandBox commandBox, Illustration illustration, List<JunctionsBySubset> junctionsBySubsetList, PermissionSummary permissionSummary, BdfUser bdfUser) {
        commandBox = commandBox.derive("JunctionRemove", "_ ALB-13").__(CommandBoxUtils.insert(illustration)).actionCssClass("action-Delete").submitLocKey("_ submit.global.junctionremove");
        hp.__start(commandBox).__(new JunctionSelection("remove", junctionsBySubsetList, bdfUser.getWorkingLang(), bdfUser.getFormatLocale())).__(BdfHtmlUtils.printJunctionRemoveWarning(hp, illustration.getSubsetKey(), permissionSummary)).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printJunctionAddBox(HtmlPrinter hp, CommandBox commandBox, Illustration illustration) {
        commandBox = commandBox.derive("JunctionAdd", "_ ALB-14").__(CommandBoxUtils.insert(illustration)).actionCssClass("action-New").submitLocKey("_ submit.global.junctionadd");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow("_ label.global.junctionadd", hp.name("add").cols(60).rows(3).populate(Appelant.fiche()))).__(Grid.END).__end(commandBox);
        return true;
    }
}

