/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.forms;

import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.localisation.Lang;

public final class CommonFormHtml {
    private CommonFormHtml() {
    }

    public static int getDefaultSize(String widthType) {
        switch (widthType) {
            case "small": {
                return 21;
            }
            case "medium": {
                return 39;
            }
            case "large": {
                return 77;
            }
        }
        return 50;
    }

    public static String getCssClass(String widthType) {
        switch (widthType) {
            case "small": {
                return "ficheform-Small";
            }
            case "medium": {
                return "ficheform-Medium";
            }
        }
        return "ficheform-Full";
    }

    public static HtmlAttributes addTextInputAttributes(HtmlAttributes inputAttrs, Attributes attributes, Lang lang) {
        String placeholder;
        Attribute placeholderAttribute = attributes.getAttribute(FicheFormSpace.getPlaceholderAttributeKey(lang));
        Attribute maxlengthAttribute = attributes.getAttribute(FicheFormSpace.MAXLENGTH_KEY);
        int maxLength = -1;
        String string = placeholder = placeholderAttribute != null ? CommonFormHtml.toString(placeholderAttribute) : null;
        if (maxlengthAttribute != null) {
            try {
                maxLength = Integer.parseInt(maxlengthAttribute.getFirstValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return inputAttrs.attr("placeholder", placeholder).attr(maxLength > 0, "maxlength", String.valueOf(maxLength));
    }

    private static String toString(Attribute attribute) {
        if (attribute.size() == 1) {
            return attribute.getFirstValue();
        }
        StringBuilder buf = new StringBuilder();
        for (String value : attribute) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(value);
        }
        return buf.toString();
    }

    public static boolean printStandardLabel(HtmlPrinter hp, FormEntry formEntry, Lang lang, String inputId) {
        HtmlAttributes labelAttrs = HA.forId(inputId).attr("data-ficheform-role", "label").classes("ficheform-standard-Label");
        CommonFormHtml.addTooltip(labelAttrs, formEntry.getAttributes(), lang);
        hp.__breakLine().LABEL(labelAttrs).__escape(formEntry.getLabel())._LABEL().__breakLine().SPAN("ficheform-standard-Colon").__escape(':')._SPAN().__breakLine();
        return true;
    }

    public static HtmlAttributes addTooltip(HtmlAttributes attrs, Attributes attributes, Lang lang) {
        Attribute tooltipAttribute = attributes.getAttribute(FicheFormSpace.getTooltipAttributeKey(lang));
        String tooltip = tooltipAttribute != null ? CommonFormHtml.toString(tooltipAttribute) : null;
        return attrs.attr("data-tooltip", tooltip);
    }

    public static boolean printComment(HtmlPrinter hp, TrustedHtml html, String goTo) {
        hp.DIV(HA.classes("ficheform-Comment").attr("data-goto", goTo)).__breakLine().__append(html).__breakLine()._DIV();
        return true;
    }
}

