/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.managers.AccessManager;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.access.v1.V1EndPointFactory;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.text.ParseException;
import net.fichotheque.exportation.access.AccessDef;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessageJsonProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.text.RelativePath;

public class AccessInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final int version;
    private final AccessDef accessDef;
    private final String endPoint;

    private AccessInstruction(BdfServer bdfServer, RequestMap requestMap, int version, AccessDef accessDef, String endPoint) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
        this.version = version;
        this.accessDef = accessDef;
        this.endPoint = endPoint;
    }

    @Override
    public short getBdfUserNeed() {
        switch (this.accessDef.getType()) {
            case "private": {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        JsonProducer jsonProducer;
        Lang lang = this.getLang(bdfUser);
        try {
            this.checkToken();
            jsonProducer = V1EndPointFactory.getJsonProducer(this.bdfServer, this.requestMap, this.accessDef, lang, this.endPoint, bdfUser);
        }
        catch (ErrorMessageException eme) {
            MessageLocalisation messageLocalisation = bdfUser != null ? this.bdfServer.getL10nManager().getMessageLocalisation(bdfUser) : this.bdfServer.getL10nManager().getMessageLocalisation(lang);
            jsonProducer = new CommandMessageJsonProducer(messageLocalisation, eme.getErrorMessage());
        }
        if (jsonProducer != null) {
            return JsonResponseHandler.build(jsonProducer, this.requestMap);
        }
        return null;
    }

    private Lang getLang(BdfUser bdfUser) {
        String langValue = this.requestMap.getParameter("lang");
        if (langValue != null) {
            try {
                Lang lang = Lang.parse(langValue);
                return lang;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (bdfUser != null) {
            return bdfUser.getWorkingLang();
        }
        return this.bdfServer.getDefaultWorkingLang();
    }

    private void checkToken() throws ErrorMessageException {
        if (!this.accessDef.getType().equals("token")) {
            return;
        }
        String validToken = this.accessDef.getToken();
        String currentToken = this.requestMap.getTrimedParameter("token");
        if (!currentToken.equals(validToken)) {
            throw BdfErrors.error("_ error.wrong.token", currentToken);
        }
    }

    public static BdfInstruction build(BdfServer bdfServer, RequestMap requestMap, String filePath) {
        BdfInstruction bdfInstruction = AccessInstruction.innerBuild(bdfServer, requestMap, filePath);
        if (bdfInstruction != null) {
            return bdfInstruction;
        }
        return BdfInstructionUtils.NOTFOUND_BDFINSTRUCTION;
    }

    private static BdfInstruction innerBuild(BdfServer bdfServer, RequestMap requestMap, String filePath) {
        RelativePath relativePath;
        try {
            relativePath = RelativePath.parse(filePath);
        }
        catch (ParseException pe) {
            return null;
        }
        String[] pathArray = relativePath.toArray();
        if (pathArray.length < 3) {
            return null;
        }
        int version = AccessInstruction.getVersion(pathArray[0]);
        if (version < 0) {
            return null;
        }
        AccessManager accessManager = bdfServer.getAccessManager();
        AccessDef accessDef = accessManager.getAccessDef(pathArray[1]);
        if (accessDef == null) {
            return null;
        }
        String endPoint = pathArray[2];
        return new AccessInstruction(bdfServer, requestMap, version, accessDef, endPoint);
    }

    private static int getVersion(String part) {
        switch (part) {
            case "v1": {
                return 1;
            }
        }
        return -1;
    }
}

