/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotcleCheckCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleCheck";
    private Thesaurus thesaurus;
    private Motcle motcle;
    private ExternalSource externalSource;
    private int newId;

    public MotcleCheckCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        if (this.motcle == null) {
            try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
                this.motcle = this.externalSource.getMotcle(session.getFichothequeEditor(), this.thesaurus, this.newId);
            }
            if (this.motcle == null) {
                throw BdfErrors.unknownParameterValue("id", String.valueOf(this.newId));
            }
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        this.putResultObject("obj.motcle", this.motcle);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.getPermissionChecker().checkSubsetAccess(this.thesaurus);
        this.externalSource = ExternalSourceUtils.getExternalSource(this.bdfServer, this.thesaurus);
        if (this.externalSource == null || this.externalSource.isIdalphaBased()) {
            this.motcle = this.requestHandler.getMandatoryMotcle();
            return;
        }
        try {
            this.motcle = this.requestHandler.getMandatoryMotcle();
        }
        catch (ErrorMessageException eme) {
            this.newId = this.requestHandler.getMandatoryId();
            this.motcle = null;
        }
    }
}

