/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SphereAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SphereAttributeChange";
    public static final String COMMANDKEY = "_ SPH-08";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Sphere sphere;
    private AttributeChange attributeChange;

    public SphereAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.sphere.getSphereMetadata(), this.attributeChange);
        }
        this.putResultObject("obj.sphere", this.sphere);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.sphere = this.requestHandler.getMandatorySphere();
        this.checkSubsetAdmin(this.sphere);
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

