/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.tools.exportation.table.DefaultTableDefFactory;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.LinkedHashSet;
import net.fichotheque.EditOrigin;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class TableExportCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportCreation";
    public static final String COMMANDKEY = "_ EXP-11";
    public static final String NEWTABLEEXPORT_PARAMNAME = "newtableexport";
    public static final String CORPUSLIST_PARAMNAME = "corpuslist";
    public static final String THESAURUSLIST_PARAMNAME = "thesauruslist";
    private FicheTableParameters ficheTableParameters;
    private String newTableExportName;
    private Corpus[] corpusArray;
    private Thesaurus[] thesaurusArray;

    public TableExportCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        TableDef tableDef;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TableExportManager manager = this.bdfServer.getTableExportManager();
        TableExportDescription tableExportDescription = null;
        if (this.corpusArray != null) {
            for (Subset subset : this.corpusArray) {
                tableDef = DefaultTableDefFactory.fromUi(this.bdfServer, (Corpus)subset, this.ficheTableParameters, this.requestHandler.getPermissionSummary());
                tableExportDescription = manager.putTableDef(this.newTableExportName, subset.getSubsetKey(), tableDef, editOrigin);
            }
        }
        if (this.thesaurusArray != null) {
            for (Subset subset : this.thesaurusArray) {
                tableDef = DefaultTableDefFactory.fromThesaurusMetadata((Thesaurus)subset, this.bdfServer.getThesaurusLangChecker());
                tableExportDescription = manager.putTableDef(this.newTableExportName, subset.getSubsetKey(), tableDef, editOrigin);
            }
        }
        if (tableExportDescription != null) {
            this.putResultObject("obj.tableexportdescription", tableExportDescription);
            this.setDone("_ done.exportation.tableexportcreation", this.newTableExportName);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String[] thesaurusNames;
        this.checkFichothequeAdmin();
        this.newTableExportName = this.getMandatory(NEWTABLEEXPORT_PARAMNAME).trim();
        if (this.newTableExportName.length() == 0) {
            throw BdfErrors.error("_ error.empty.exportname");
        }
        if (!StringUtils.isTechnicalName(this.newTableExportName, true)) {
            throw BdfErrors.error("_ error.wrong.exportname", this.newTableExportName);
        }
        if (this.bdfServer.getTableExportManager().containsTableExport(this.newTableExportName)) {
            throw BdfErrors.error("_ error.existing.tableexport", this.newTableExportName);
        }
        this.ficheTableParameters = this.requestHandler.getFicheTableParameters();
        String[] corpusNames = this.requestHandler.getTokens(CORPUSLIST_PARAMNAME);
        if (corpusNames.length > 0) {
            LinkedHashSet<Corpus> set = new LinkedHashSet<Corpus>();
            for (String corpusName : corpusNames) {
                try {
                    SubsetKey corpusKey = SubsetKey.parse((short)1, corpusName);
                    Corpus corpus = (Corpus)this.fichotheque.getSubset(corpusKey);
                    if (corpus == null) continue;
                    set.add(corpus);
                }
                catch (ParseException corpus) {
                    // empty catch block
                }
            }
            this.corpusArray = set.toArray(new Corpus[set.size()]);
        }
        if ((thesaurusNames = this.requestHandler.getTokens(THESAURUSLIST_PARAMNAME)).length > 0) {
            LinkedHashSet<Thesaurus> set = new LinkedHashSet<Thesaurus>();
            for (String thesaurusName : thesaurusNames) {
                try {
                    SubsetKey thesaurusKey = SubsetKey.parse((short)2, thesaurusName);
                    Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(thesaurusKey);
                    if (thesaurus == null) continue;
                    set.add(thesaurus);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.thesaurusArray = set.toArray(new Thesaurus[set.size()]);
        }
        if (thesaurusNames.length == 0 && corpusNames.length == 0) {
            this.corpusArray = FichothequeUtils.toCorpusArray(this.fichotheque, EligibilityUtils.ALL_SUBSET_PREDICATE);
        }
    }
}

